/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest;
import com.google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse;
import com.google.cloud.compute.v1.GetGlobalOrganizationOperationRequest;
import com.google.cloud.compute.v1.GlobalOrganizationOperationsSettings;
import com.google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.stub.GlobalOrganizationOperationsStub;
import com.google.cloud.compute.v1.stub.GlobalOrganizationOperationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GlobalOrganizationOperationsClient
implements BackgroundResource {
    private final GlobalOrganizationOperationsSettings settings;
    private final GlobalOrganizationOperationsStub stub;

    public static final GlobalOrganizationOperationsClient create() throws IOException {
        return GlobalOrganizationOperationsClient.create(GlobalOrganizationOperationsSettings.newBuilder().build());
    }

    public static final GlobalOrganizationOperationsClient create(GlobalOrganizationOperationsSettings settings) throws IOException {
        return new GlobalOrganizationOperationsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalOrganizationOperationsClient create(GlobalOrganizationOperationsStub stub) {
        return new GlobalOrganizationOperationsClient(stub);
    }

    protected GlobalOrganizationOperationsClient(GlobalOrganizationOperationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalOrganizationOperationsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalOrganizationOperationsClient(GlobalOrganizationOperationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalOrganizationOperationsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalOrganizationOperationsStub getStub() {
        return this.stub;
    }

    public final DeleteGlobalOrganizationOperationResponse delete(String operation) {
        DeleteGlobalOrganizationOperationRequest request = DeleteGlobalOrganizationOperationRequest.newBuilder().setOperation(operation).build();
        return this.delete(request);
    }

    public final DeleteGlobalOrganizationOperationResponse delete(DeleteGlobalOrganizationOperationRequest request) {
        return (DeleteGlobalOrganizationOperationResponse)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlobalOrganizationOperationRequest, DeleteGlobalOrganizationOperationResponse> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation get(String operation) {
        GetGlobalOrganizationOperationRequest request = GetGlobalOrganizationOperationRequest.newBuilder().setOperation(operation).build();
        return this.get(request);
    }

    public final Operation get(GetGlobalOrganizationOperationRequest request) {
        return (Operation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalOrganizationOperationRequest, Operation> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list() {
        ListGlobalOrganizationOperationsRequest request = ListGlobalOrganizationOperationsRequest.newBuilder().build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalOrganizationOperationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalOrganizationOperationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalOrganizationOperationsRequest, OperationList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalOrganizationOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalOrganizationOperationsRequest, OperationList, Operation, ListPage> {
        private ListPage(PageContext<ListGlobalOrganizationOperationsRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalOrganizationOperationsRequest, OperationList, Operation> context, OperationList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalOrganizationOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalOrganizationOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalOrganizationOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

