/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddNodesNodeGroupRequest;
import com.google.cloud.compute.v1.AggregatedListNodeGroupsRequest;
import com.google.cloud.compute.v1.DeleteNodeGroupRequest;
import com.google.cloud.compute.v1.DeleteNodesNodeGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeGroupRequest;
import com.google.cloud.compute.v1.GetNodeGroupRequest;
import com.google.cloud.compute.v1.InsertNodeGroupRequest;
import com.google.cloud.compute.v1.ListNodeGroupsRequest;
import com.google.cloud.compute.v1.ListNodesNodeGroupsRequest;
import com.google.cloud.compute.v1.NodeGroup;
import com.google.cloud.compute.v1.NodeGroupAggregatedList;
import com.google.cloud.compute.v1.NodeGroupList;
import com.google.cloud.compute.v1.NodeGroupNode;
import com.google.cloud.compute.v1.NodeGroupsClient;
import com.google.cloud.compute.v1.NodeGroupsListNodes;
import com.google.cloud.compute.v1.NodeGroupsScopedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNodeGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyNodeGroupRequest;
import com.google.cloud.compute.v1.SetNodeTemplateNodeGroupRequest;
import com.google.cloud.compute.v1.SimulateMaintenanceEventNodeGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNodeGroupsStub;
import com.google.cloud.compute.v1.stub.NodeGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class NodeGroupsStubSettings
extends StubSettings<NodeGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddNodesNodeGroupRequest, Operation> addNodesSettings;
    private final OperationCallSettings<AddNodesNodeGroupRequest, Operation, Operation> addNodesOperationSettings;
    private final PagedCallSettings<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, NodeGroupsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteNodeGroupRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteNodeGroupRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteNodesNodeGroupRequest, Operation> deleteNodesSettings;
    private final OperationCallSettings<DeleteNodesNodeGroupRequest, Operation, Operation> deleteNodesOperationSettings;
    private final UnaryCallSettings<GetNodeGroupRequest, NodeGroup> getSettings;
    private final UnaryCallSettings<GetIamPolicyNodeGroupRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertNodeGroupRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertNodeGroupRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListNodeGroupsRequest, NodeGroupList, NodeGroupsClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupsClient.ListNodesPagedResponse> listNodesSettings;
    private final UnaryCallSettings<PatchNodeGroupRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchNodeGroupRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetIamPolicyNodeGroupRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateSettings;
    private final OperationCallSettings<SetNodeTemplateNodeGroupRequest, Operation, Operation> setNodeTemplateOperationSettings;
    private final UnaryCallSettings<SimulateMaintenanceEventNodeGroupRequest, Operation> simulateMaintenanceEventSettings;
    private final OperationCallSettings<SimulateMaintenanceEventNodeGroupRequest, Operation, Operation> simulateMaintenanceEventOperationSettings;
    private final UnaryCallSettings<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNodeGroupsRequest injectToken(AggregatedListNodeGroupsRequest payload, String token) {
            return AggregatedListNodeGroupsRequest.newBuilder((AggregatedListNodeGroupsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListNodeGroupsRequest injectPageSize(AggregatedListNodeGroupsRequest payload, int pageSize) {
            return AggregatedListNodeGroupsRequest.newBuilder((AggregatedListNodeGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNodeGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeGroupAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, NodeGroupsScopedList>> extractResources(NodeGroupAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListNodeGroupsRequest, NodeGroupList, NodeGroup> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNodeGroupsRequest, NodeGroupList, NodeGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListNodeGroupsRequest injectToken(ListNodeGroupsRequest payload, String token) {
            return ListNodeGroupsRequest.newBuilder((ListNodeGroupsRequest)payload).setPageToken(token).build();
        }

        public ListNodeGroupsRequest injectPageSize(ListNodeGroupsRequest payload, int pageSize) {
            return ListNodeGroupsRequest.newBuilder((ListNodeGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodeGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeGroup> extractResources(NodeGroupList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode> LIST_NODES_PAGE_STR_DESC = new PagedListDescriptor<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode>(){

        public String emptyToken() {
            return "";
        }

        public ListNodesNodeGroupsRequest injectToken(ListNodesNodeGroupsRequest payload, String token) {
            return ListNodesNodeGroupsRequest.newBuilder((ListNodesNodeGroupsRequest)payload).setPageToken(token).build();
        }

        public ListNodesNodeGroupsRequest injectPageSize(ListNodesNodeGroupsRequest payload, int pageSize) {
            return ListNodesNodeGroupsRequest.newBuilder((ListNodesNodeGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodesNodeGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeGroupsListNodes payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeGroupNode> extractResources(NodeGroupsListNodes payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, NodeGroupsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, NodeGroupsClient.AggregatedListPagedResponse>(){

        public ApiFuture<NodeGroupsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList> callable, AggregatedListNodeGroupsRequest request, ApiCallContext context, ApiFuture<NodeGroupAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeGroupsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, Map.Entry<String, NodeGroupsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodeGroupsRequest, NodeGroupList, NodeGroupsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNodeGroupsRequest, NodeGroupList, NodeGroupsClient.ListPagedResponse>(){

        public ApiFuture<NodeGroupsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodeGroupsRequest, NodeGroupList> callable, ListNodeGroupsRequest request, ApiCallContext context, ApiFuture<NodeGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeGroupsClient.ListPagedResponse.createAsync((PageContext<ListNodeGroupsRequest, NodeGroupList, NodeGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupsClient.ListNodesPagedResponse> LIST_NODES_PAGE_STR_FACT = new PagedListResponseFactory<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupsClient.ListNodesPagedResponse>(){

        public ApiFuture<NodeGroupsClient.ListNodesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodesNodeGroupsRequest, NodeGroupsListNodes> callable, ListNodesNodeGroupsRequest request, ApiCallContext context, ApiFuture<NodeGroupsListNodes> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeGroupsClient.ListNodesPagedResponse.createAsync((PageContext<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupNode>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddNodesNodeGroupRequest, Operation> addNodesSettings() {
        return this.addNodesSettings;
    }

    public OperationCallSettings<AddNodesNodeGroupRequest, Operation, Operation> addNodesOperationSettings() {
        return this.addNodesOperationSettings;
    }

    public PagedCallSettings<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, NodeGroupsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteNodeGroupRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteNodeGroupRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteNodesNodeGroupRequest, Operation> deleteNodesSettings() {
        return this.deleteNodesSettings;
    }

    public OperationCallSettings<DeleteNodesNodeGroupRequest, Operation, Operation> deleteNodesOperationSettings() {
        return this.deleteNodesOperationSettings;
    }

    public UnaryCallSettings<GetNodeGroupRequest, NodeGroup> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyNodeGroupRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertNodeGroupRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertNodeGroupRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListNodeGroupsRequest, NodeGroupList, NodeGroupsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupsClient.ListNodesPagedResponse> listNodesSettings() {
        return this.listNodesSettings;
    }

    public UnaryCallSettings<PatchNodeGroupRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchNodeGroupRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyNodeGroupRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateSettings() {
        return this.setNodeTemplateSettings;
    }

    public OperationCallSettings<SetNodeTemplateNodeGroupRequest, Operation, Operation> setNodeTemplateOperationSettings() {
        return this.setNodeTemplateOperationSettings;
    }

    public UnaryCallSettings<SimulateMaintenanceEventNodeGroupRequest, Operation> simulateMaintenanceEventSettings() {
        return this.simulateMaintenanceEventSettings;
    }

    public OperationCallSettings<SimulateMaintenanceEventNodeGroupRequest, Operation, Operation> simulateMaintenanceEventOperationSettings() {
        return this.simulateMaintenanceEventOperationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public NodeGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNodeGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NodeGroupsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NodeGroupsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NodeGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addNodesSettings = settingsBuilder.addNodesSettings().build();
        this.addNodesOperationSettings = settingsBuilder.addNodesOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteNodesSettings = settingsBuilder.deleteNodesSettings().build();
        this.deleteNodesOperationSettings = settingsBuilder.deleteNodesOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listNodesSettings = settingsBuilder.listNodesSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setNodeTemplateSettings = settingsBuilder.setNodeTemplateSettings().build();
        this.setNodeTemplateOperationSettings = settingsBuilder.setNodeTemplateOperationSettings().build();
        this.simulateMaintenanceEventSettings = settingsBuilder.simulateMaintenanceEventSettings().build();
        this.simulateMaintenanceEventOperationSettings = settingsBuilder.simulateMaintenanceEventOperationSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NodeGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddNodesNodeGroupRequest, Operation> addNodesSettings;
        private final OperationCallSettings.Builder<AddNodesNodeGroupRequest, Operation, Operation> addNodesOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, NodeGroupsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteNodeGroupRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteNodeGroupRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNodesNodeGroupRequest, Operation> deleteNodesSettings;
        private final OperationCallSettings.Builder<DeleteNodesNodeGroupRequest, Operation, Operation> deleteNodesOperationSettings;
        private final UnaryCallSettings.Builder<GetNodeGroupRequest, NodeGroup> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyNodeGroupRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertNodeGroupRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertNodeGroupRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListNodeGroupsRequest, NodeGroupList, NodeGroupsClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupsClient.ListNodesPagedResponse> listNodesSettings;
        private final UnaryCallSettings.Builder<PatchNodeGroupRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchNodeGroupRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyNodeGroupRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateSettings;
        private final OperationCallSettings.Builder<SetNodeTemplateNodeGroupRequest, Operation, Operation> setNodeTemplateOperationSettings;
        private final UnaryCallSettings.Builder<SimulateMaintenanceEventNodeGroupRequest, Operation> simulateMaintenanceEventSettings;
        private final OperationCallSettings.Builder<SimulateMaintenanceEventNodeGroupRequest, Operation, Operation> simulateMaintenanceEventOperationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addNodesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addNodesOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteNodesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNodesOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listNodesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODES_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNodeTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.simulateMaintenanceEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.simulateMaintenanceEventOperationSettings = OperationCallSettings.newBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addNodesSettings, this.aggregatedListSettings, this.deleteSettings, this.deleteNodesSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listNodesSettings, this.patchSettings, this.setIamPolicySettings, this.setNodeTemplateSettings, (Object[])new UnaryCallSettings.Builder[]{this.simulateMaintenanceEventSettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(NodeGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.addNodesSettings = settings.addNodesSettings.toBuilder();
            this.addNodesOperationSettings = settings.addNodesOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteNodesSettings = settings.deleteNodesSettings.toBuilder();
            this.deleteNodesOperationSettings = settings.deleteNodesOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listNodesSettings = settings.listNodesSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setNodeTemplateSettings = settings.setNodeTemplateSettings.toBuilder();
            this.setNodeTemplateOperationSettings = settings.setNodeTemplateOperationSettings.toBuilder();
            this.simulateMaintenanceEventSettings = settings.simulateMaintenanceEventSettings.toBuilder();
            this.simulateMaintenanceEventOperationSettings = settings.simulateMaintenanceEventOperationSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addNodesSettings, this.aggregatedListSettings, this.deleteSettings, this.deleteNodesSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listNodesSettings, this.patchSettings, this.setIamPolicySettings, this.setNodeTemplateSettings, (Object[])new UnaryCallSettings.Builder[]{this.simulateMaintenanceEventSettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NodeGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NodeGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NodeGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NodeGroupsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(NodeGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addNodesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteNodesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listNodesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.simulateMaintenanceEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addNodesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteNodesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setNodeTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.simulateMaintenanceEventOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddNodesNodeGroupRequest, Operation> addNodesSettings() {
            return this.addNodesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddNodesNodeGroupRequest, Operation, Operation> addNodesOperationSettings() {
            return this.addNodesOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, NodeGroupsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodeGroupRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteNodeGroupRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodesNodeGroupRequest, Operation> deleteNodesSettings() {
            return this.deleteNodesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteNodesNodeGroupRequest, Operation, Operation> deleteNodesOperationSettings() {
            return this.deleteNodesOperationSettings;
        }

        public UnaryCallSettings.Builder<GetNodeGroupRequest, NodeGroup> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyNodeGroupRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertNodeGroupRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertNodeGroupRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListNodeGroupsRequest, NodeGroupList, NodeGroupsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListNodesNodeGroupsRequest, NodeGroupsListNodes, NodeGroupsClient.ListNodesPagedResponse> listNodesSettings() {
            return this.listNodesSettings;
        }

        public UnaryCallSettings.Builder<PatchNodeGroupRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PatchNodeGroupRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyNodeGroupRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateSettings() {
            return this.setNodeTemplateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetNodeTemplateNodeGroupRequest, Operation, Operation> setNodeTemplateOperationSettings() {
            return this.setNodeTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<SimulateMaintenanceEventNodeGroupRequest, Operation> simulateMaintenanceEventSettings() {
            return this.simulateMaintenanceEventSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SimulateMaintenanceEventNodeGroupRequest, Operation, Operation> simulateMaintenanceEventOperationSettings() {
            return this.simulateMaintenanceEventOperationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public NodeGroupsStubSettings build() throws IOException {
            return new NodeGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

