/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListInterconnectAttachmentsRequest;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.InterconnectAttachment;
import com.google.cloud.compute.v1.InterconnectAttachmentAggregatedList;
import com.google.cloud.compute.v1.InterconnectAttachmentList;
import com.google.cloud.compute.v1.InterconnectAttachmentsClient;
import com.google.cloud.compute.v1.InterconnectAttachmentsScopedList;
import com.google.cloud.compute.v1.ListInterconnectAttachmentsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectAttachmentsStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class InterconnectAttachmentsStubSettings
extends StubSettings<InterconnectAttachmentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteInterconnectAttachmentRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetInterconnectAttachmentRequest, InterconnectAttachment> getSettings;
    private final UnaryCallSettings<InsertInterconnectAttachmentRequest, Operation> insertSettings;
    private final PagedCallSettings<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachmentsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchInterconnectAttachmentRequest, Operation> patchSettings;
    private static final PagedListDescriptor<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInterconnectAttachmentsRequest injectToken(AggregatedListInterconnectAttachmentsRequest payload, String token) {
            return AggregatedListInterconnectAttachmentsRequest.newBuilder((AggregatedListInterconnectAttachmentsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListInterconnectAttachmentsRequest injectPageSize(AggregatedListInterconnectAttachmentsRequest payload, int pageSize) {
            return AggregatedListInterconnectAttachmentsRequest.newBuilder((AggregatedListInterconnectAttachmentsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInterconnectAttachmentsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectAttachmentAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, InterconnectAttachmentsScopedList>> extractResources(InterconnectAttachmentAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectAttachmentsRequest injectToken(ListInterconnectAttachmentsRequest payload, String token) {
            return ListInterconnectAttachmentsRequest.newBuilder((ListInterconnectAttachmentsRequest)payload).setPageToken(token).build();
        }

        public ListInterconnectAttachmentsRequest injectPageSize(ListInterconnectAttachmentsRequest payload, int pageSize) {
            return ListInterconnectAttachmentsRequest.newBuilder((ListInterconnectAttachmentsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectAttachmentsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectAttachmentList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectAttachment> extractResources(InterconnectAttachmentList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsClient.AggregatedListPagedResponse>(){

        public ApiFuture<InterconnectAttachmentsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList> callable, AggregatedListInterconnectAttachmentsRequest request, ApiCallContext context, ApiFuture<InterconnectAttachmentAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectAttachmentsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachmentsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachmentsClient.ListPagedResponse>(){

        public ApiFuture<InterconnectAttachmentsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectAttachmentsRequest, InterconnectAttachmentList> callable, ListInterconnectAttachmentsRequest request, ApiCallContext context, ApiFuture<InterconnectAttachmentList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectAttachmentsClient.ListPagedResponse.createAsync((PageContext<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteInterconnectAttachmentRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetInterconnectAttachmentRequest, InterconnectAttachment> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertInterconnectAttachmentRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachmentsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchInterconnectAttachmentRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectAttachmentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInterconnectAttachmentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InterconnectAttachmentsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InterconnectAttachmentsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InterconnectAttachmentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InterconnectAttachmentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteInterconnectAttachmentRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetInterconnectAttachmentRequest, InterconnectAttachment> getSettings;
        private final UnaryCallSettings.Builder<InsertInterconnectAttachmentRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachmentsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchInterconnectAttachmentRequest, Operation> patchSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings);
            Builder.initDefaults(this);
        }

        protected Builder(InterconnectAttachmentsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InterconnectAttachmentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InterconnectAttachmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InterconnectAttachmentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InterconnectAttachmentsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(InterconnectAttachmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteInterconnectAttachmentRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetInterconnectAttachmentRequest, InterconnectAttachment> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertInterconnectAttachmentRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachmentsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchInterconnectAttachmentRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public InterconnectAttachmentsStubSettings build() throws IOException {
            return new InterconnectAttachmentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

