/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListResourcePoliciesRequest;
import com.google.cloud.compute.v1.DeleteResourcePolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyResourcePolicyRequest;
import com.google.cloud.compute.v1.GetResourcePolicyRequest;
import com.google.cloud.compute.v1.InsertResourcePolicyRequest;
import com.google.cloud.compute.v1.ListResourcePoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ResourcePoliciesClient;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.ResourcePolicyAggregatedList;
import com.google.cloud.compute.v1.ResourcePolicyList;
import com.google.cloud.compute.v1.SetIamPolicyResourcePolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsResourcePolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonResourcePoliciesCallableFactory;
import com.google.cloud.compute.v1.stub.ResourcePoliciesStub;
import com.google.cloud.compute.v1.stub.ResourcePoliciesStubSettings;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonResourcePoliciesStub
extends ResourcePoliciesStub {
    private static final ApiMethodDescriptor<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList> aggregatedListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/AggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/aggregated/resourcePolicies", (FieldsExtractor)new FieldsExtractor<AggregatedListResourcePoliciesRequest, Map<String, String>>(){

        public Map<String, String> extract(AggregatedListResourcePoliciesRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListResourcePoliciesRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(AggregatedListResourcePoliciesRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasIncludeAllScopes()) {
                serializer.putQueryParam(fields, "includeAllScopes", (Object)request.getIncludeAllScopes());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListResourcePoliciesRequest, String>(){

        public String extract(AggregatedListResourcePoliciesRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResourcePolicyAggregatedList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<DeleteResourcePolicyRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}", (FieldsExtractor)new FieldsExtractor<DeleteResourcePolicyRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteResourcePolicyRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            serializer.putPathParam(fields, "resourcePolicy", (Object)request.getResourcePolicy());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteResourcePolicyRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteResourcePolicyRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteResourcePolicyRequest, String>(){

        public String extract(DeleteResourcePolicyRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetResourcePolicyRequest, ResourcePolicy> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}", (FieldsExtractor)new FieldsExtractor<GetResourcePolicyRequest, Map<String, String>>(){

        public Map<String, String> extract(GetResourcePolicyRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            serializer.putPathParam(fields, "resourcePolicy", (Object)request.getResourcePolicy());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetResourcePolicyRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetResourcePolicyRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetResourcePolicyRequest, String>(){

        public String extract(GetResourcePolicyRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResourcePolicy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/GetIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy", (FieldsExtractor)new FieldsExtractor<GetIamPolicyResourcePolicyRequest, Map<String, String>>(){

        public Map<String, String> extract(GetIamPolicyResourcePolicyRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyResourcePolicyRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetIamPolicyResourcePolicyRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasOptionsRequestedPolicyVersion()) {
                serializer.putQueryParam(fields, "optionsRequestedPolicyVersion", (Object)request.getOptionsRequestedPolicyVersion());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyResourcePolicyRequest, String>(){

        public String extract(GetIamPolicyResourcePolicyRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<InsertResourcePolicyRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies", (FieldsExtractor)new FieldsExtractor<InsertResourcePolicyRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertResourcePolicyRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertResourcePolicyRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertResourcePolicyRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertResourcePolicyRequest, String>(){

        public String extract(InsertResourcePolicyRequest request) {
            return ProtoRestSerializer.create().toBody("resourcePolicyResource", (Message)request.getResourcePolicyResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<ListResourcePoliciesRequest, ResourcePolicyList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies", (FieldsExtractor)new FieldsExtractor<ListResourcePoliciesRequest, Map<String, String>>(){

        public Map<String, String> extract(ListResourcePoliciesRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListResourcePoliciesRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListResourcePoliciesRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListResourcePoliciesRequest, String>(){

        public String extract(ListResourcePoliciesRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResourcePolicyList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/SetIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy", (FieldsExtractor)new FieldsExtractor<SetIamPolicyResourcePolicyRequest, Map<String, String>>(){

        public Map<String, String> extract(SetIamPolicyResourcePolicyRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyResourcePolicyRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(SetIamPolicyResourcePolicyRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyResourcePolicyRequest, String>(){

        public String extract(SetIamPolicyResourcePolicyRequest request) {
            return ProtoRestSerializer.create().toBody("regionSetPolicyRequestResource", (Message)request.getRegionSetPolicyRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ResourcePolicies/TestIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resource}/testIamPermissions", (FieldsExtractor)new FieldsExtractor<TestIamPermissionsResourcePolicyRequest, Map<String, String>>(){

        public Map<String, String> extract(TestIamPermissionsResourcePolicyRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "region", (Object)request.getRegion());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsResourcePolicyRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(TestIamPermissionsResourcePolicyRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsResourcePolicyRequest, String>(){

        public String extract(TestIamPermissionsResourcePolicyRequest request) {
            return ProtoRestSerializer.create().toBody("testPermissionsRequestResource", (Message)request.getTestPermissionsRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final UnaryCallable<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList> aggregatedListCallable;
    private final UnaryCallable<AggregatedListResourcePoliciesRequest, ResourcePoliciesClient.AggregatedListPagedResponse> aggregatedListPagedCallable;
    private final UnaryCallable<DeleteResourcePolicyRequest, Operation> deleteCallable;
    private final UnaryCallable<GetResourcePolicyRequest, ResourcePolicy> getCallable;
    private final UnaryCallable<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<InsertResourcePolicyRequest, Operation> insertCallable;
    private final UnaryCallable<ListResourcePoliciesRequest, ResourcePolicyList> listCallable;
    private final UnaryCallable<ListResourcePoliciesRequest, ResourcePoliciesClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonResourcePoliciesStub create(ResourcePoliciesStubSettings settings) throws IOException {
        return new HttpJsonResourcePoliciesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonResourcePoliciesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonResourcePoliciesStub(ResourcePoliciesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonResourcePoliciesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonResourcePoliciesStub(ResourcePoliciesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonResourcePoliciesStub(ResourcePoliciesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonResourcePoliciesCallableFactory());
    }

    protected HttpJsonResourcePoliciesStub(ResourcePoliciesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListMethodDescriptor).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).build();
        this.aggregatedListCallable = callableFactory.createUnaryCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.aggregatedListPagedCallable = callableFactory.createPagedCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(aggregatedListMethodDescriptor);
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList> aggregatedListCallable() {
        return this.aggregatedListCallable;
    }

    @Override
    public UnaryCallable<AggregatedListResourcePoliciesRequest, ResourcePoliciesClient.AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.aggregatedListPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteResourcePolicyRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetResourcePolicyRequest, ResourcePolicy> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<InsertResourcePolicyRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListResourcePoliciesRequest, ResourcePolicyList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListResourcePoliciesRequest, ResourcePoliciesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

