/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionNotificationEndpointRequest;
import com.google.cloud.compute.v1.GetRegionNotificationEndpointRequest;
import com.google.cloud.compute.v1.InsertRegionNotificationEndpointRequest;
import com.google.cloud.compute.v1.ListRegionNotificationEndpointsRequest;
import com.google.cloud.compute.v1.NotificationEndpoint;
import com.google.cloud.compute.v1.NotificationEndpointList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionNotificationEndpointsSettings;
import com.google.cloud.compute.v1.stub.RegionNotificationEndpointsStub;
import com.google.cloud.compute.v1.stub.RegionNotificationEndpointsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionNotificationEndpointsClient
implements BackgroundResource {
    private final RegionNotificationEndpointsSettings settings;
    private final RegionNotificationEndpointsStub stub;

    public static final RegionNotificationEndpointsClient create() throws IOException {
        return RegionNotificationEndpointsClient.create(RegionNotificationEndpointsSettings.newBuilder().build());
    }

    public static final RegionNotificationEndpointsClient create(RegionNotificationEndpointsSettings settings) throws IOException {
        return new RegionNotificationEndpointsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionNotificationEndpointsClient create(RegionNotificationEndpointsStub stub) {
        return new RegionNotificationEndpointsClient(stub);
    }

    protected RegionNotificationEndpointsClient(RegionNotificationEndpointsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionNotificationEndpointsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionNotificationEndpointsClient(RegionNotificationEndpointsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionNotificationEndpointsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionNotificationEndpointsStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String region, String notificationEndpoint) {
        DeleteRegionNotificationEndpointRequest request = DeleteRegionNotificationEndpointRequest.newBuilder().setProject(project).setRegion(region).setNotificationEndpoint(notificationEndpoint).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionNotificationEndpointRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionNotificationEndpointRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final NotificationEndpoint get(String project, String region, String notificationEndpoint) {
        GetRegionNotificationEndpointRequest request = GetRegionNotificationEndpointRequest.newBuilder().setProject(project).setRegion(region).setNotificationEndpoint(notificationEndpoint).build();
        return this.get(request);
    }

    public final NotificationEndpoint get(GetRegionNotificationEndpointRequest request) {
        return (NotificationEndpoint)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionNotificationEndpointRequest, NotificationEndpoint> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, NotificationEndpoint notificationEndpointResource) {
        InsertRegionNotificationEndpointRequest request = InsertRegionNotificationEndpointRequest.newBuilder().setProject(project).setRegion(region).setNotificationEndpointResource(notificationEndpointResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionNotificationEndpointRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionNotificationEndpointRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionNotificationEndpointsRequest request = ListRegionNotificationEndpointsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionNotificationEndpointsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionNotificationEndpointsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionNotificationEndpointsRequest, NotificationEndpointList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint, ListPage> {
        private ListPage(PageContext<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint> context, NotificationEndpointList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint> context, NotificationEndpointList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint> context, ApiFuture<NotificationEndpointList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionNotificationEndpointsRequest, NotificationEndpointList, NotificationEndpoint> context, ApiFuture<NotificationEndpointList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

