/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.GetRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.InsertRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.ListRegionTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetTcpProxiesClient;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonRegionTargetTcpProxiesCallableFactory;
import com.google.cloud.compute.v1.stub.RegionTargetTcpProxiesStub;
import com.google.cloud.compute.v1.stub.RegionTargetTcpProxiesStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRegionTargetTcpProxiesStub
extends RegionTargetTcpProxiesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<DeleteRegionTargetTcpProxyRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionTargetTcpProxies/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "targetTcpProxy", (Object)request.getTargetTcpProxy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionTargetTcpProxies/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "targetTcpProxy", (Object)request.getTargetTcpProxy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TargetTcpProxy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertRegionTargetTcpProxyRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionTargetTcpProxies/Insert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/targetTcpProxies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("targetTcpProxyResource", (Message)request.getTargetTcpProxyResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionTargetTcpProxies/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/targetTcpProxies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TargetTcpProxyList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<DeleteRegionTargetTcpProxyRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getCallable;
    private final UnaryCallable<InsertRegionTargetTcpProxyRequest, Operation> insertCallable;
    private final OperationCallable<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList> listCallable;
    private final UnaryCallable<ListRegionTargetTcpProxiesRequest, RegionTargetTcpProxiesClient.ListPagedResponse> listPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonRegionOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionTargetTcpProxiesStub create(RegionTargetTcpProxiesStubSettings settings) throws IOException {
        return new HttpJsonRegionTargetTcpProxiesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionTargetTcpProxiesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionTargetTcpProxiesStub(RegionTargetTcpProxiesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionTargetTcpProxiesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionTargetTcpProxiesStub(RegionTargetTcpProxiesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionTargetTcpProxiesStub(RegionTargetTcpProxiesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionTargetTcpProxiesCallableFactory());
    }

    protected HttpJsonRegionTargetTcpProxiesStub(RegionTargetTcpProxiesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonRegionOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("target_tcp_proxy", String.valueOf(request.getTargetTcpProxy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("target_tcp_proxy", String.valueOf(request.getTargetTcpProxy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            return builder.build();
        }).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DeleteRegionTargetTcpProxyRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertRegionTargetTcpProxyRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListRegionTargetTcpProxiesRequest, RegionTargetTcpProxiesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

