/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesRegionDiskRequest;
import com.google.cloud.compute.v1.CreateSnapshotRegionDiskRequest;
import com.google.cloud.compute.v1.DeleteRegionDiskRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.GetIamPolicyRegionDiskRequest;
import com.google.cloud.compute.v1.GetRegionDiskRequest;
import com.google.cloud.compute.v1.InsertRegionDiskRequest;
import com.google.cloud.compute.v1.ListRegionDisksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionDisksClient;
import com.google.cloud.compute.v1.RemoveResourcePoliciesRegionDiskRequest;
import com.google.cloud.compute.v1.ResizeRegionDiskRequest;
import com.google.cloud.compute.v1.SetIamPolicyRegionDiskRequest;
import com.google.cloud.compute.v1.SetLabelsRegionDiskRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionDiskRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateRegionDiskRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionDisksCallableFactory;
import com.google.cloud.compute.v1.stub.HttpJsonRegionOperationsStub;
import com.google.cloud.compute.v1.stub.RegionDisksStub;
import com.google.cloud.compute.v1.stub.RegionDisksStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRegionDisksStub
extends RegionDisksStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/AddResourcePolicies").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}/addResourcePolicies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionDisksAddResourcePoliciesRequestResource", (Message)request.getRegionDisksAddResourcePoliciesRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<CreateSnapshotRegionDiskRequest, Operation> createSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/CreateSnapshot").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}/createSnapshot", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("snapshotResource", (Message)request.getSnapshotResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<DeleteRegionDiskRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetRegionDiskRequest, Disk> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Disk.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRegionDiskRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{resource}/getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasOptionsRequestedPolicyVersion()) {
            serializer.putQueryParam(fields, "optionsRequestedPolicyVersion", (Object)request.getOptionsRequestedPolicyVersion());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertRegionDiskRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/Insert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        if (request.hasSourceImage()) {
            serializer.putQueryParam(fields, "sourceImage", (Object)request.getSourceImage());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("diskResource", (Message)request.getDiskResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListRegionDisksRequest, DiskList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DiskList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/RemoveResourcePolicies").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}/removeResourcePolicies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionDisksRemoveResourcePoliciesRequestResource", (Message)request.getRegionDisksRemoveResourcePoliciesRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ResizeRegionDiskRequest, Operation> resizeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/Resize").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}/resize", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionDisksResizeRequestResource", (Message)request.getRegionDisksResizeRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetIamPolicyRegionDiskRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{resource}/setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionSetPolicyRequestResource", (Message)request.getRegionSetPolicyRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetLabelsRegionDiskRequest, Operation> setLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/SetLabels").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{resource}/setLabels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionSetLabelsRequestResource", (Message)request.getRegionSetLabelsRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{resource}/testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("testPermissionsRequestResource", (Message)request.getTestPermissionsRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRegionDiskRequest, Operation> updateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionDisks/Update").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/disks/{disk}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "disk", (Object)request.getDisk());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasPaths()) {
            serializer.putQueryParam(fields, "paths", (Object)request.getPaths());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        if (request.hasUpdateMask()) {
            serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("diskResource", (Message)request.getDiskResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesCallable;
    private final OperationCallable<AddResourcePoliciesRegionDiskRequest, Operation, Operation> addResourcePoliciesOperationCallable;
    private final UnaryCallable<CreateSnapshotRegionDiskRequest, Operation> createSnapshotCallable;
    private final OperationCallable<CreateSnapshotRegionDiskRequest, Operation, Operation> createSnapshotOperationCallable;
    private final UnaryCallable<DeleteRegionDiskRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteRegionDiskRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetRegionDiskRequest, Disk> getCallable;
    private final UnaryCallable<GetIamPolicyRegionDiskRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<InsertRegionDiskRequest, Operation> insertCallable;
    private final OperationCallable<InsertRegionDiskRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListRegionDisksRequest, DiskList> listCallable;
    private final UnaryCallable<ListRegionDisksRequest, RegionDisksClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesCallable;
    private final OperationCallable<RemoveResourcePoliciesRegionDiskRequest, Operation, Operation> removeResourcePoliciesOperationCallable;
    private final UnaryCallable<ResizeRegionDiskRequest, Operation> resizeCallable;
    private final OperationCallable<ResizeRegionDiskRequest, Operation, Operation> resizeOperationCallable;
    private final UnaryCallable<SetIamPolicyRegionDiskRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<SetLabelsRegionDiskRequest, Operation> setLabelsCallable;
    private final OperationCallable<SetLabelsRegionDiskRequest, Operation, Operation> setLabelsOperationCallable;
    private final UnaryCallable<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsCallable;
    private final UnaryCallable<UpdateRegionDiskRequest, Operation> updateCallable;
    private final OperationCallable<UpdateRegionDiskRequest, Operation, Operation> updateOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonRegionOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionDisksStub create(RegionDisksStubSettings settings) throws IOException {
        return new HttpJsonRegionDisksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionDisksStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionDisksStub(RegionDisksStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionDisksStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionDisksStub(RegionDisksStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionDisksStub(RegionDisksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionDisksCallableFactory());
    }

    protected HttpJsonRegionDisksStub(RegionDisksStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonRegionOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings addResourcePoliciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addResourcePoliciesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSnapshotMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings removeResourcePoliciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeResourcePoliciesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings resizeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resizeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.addResourcePoliciesCallable = callableFactory.createUnaryCallable(addResourcePoliciesTransportSettings, settings.addResourcePoliciesSettings(), clientContext);
        this.addResourcePoliciesOperationCallable = callableFactory.createOperationCallable(addResourcePoliciesTransportSettings, settings.addResourcePoliciesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createSnapshotCallable = callableFactory.createUnaryCallable(createSnapshotTransportSettings, settings.createSnapshotSettings(), clientContext);
        this.createSnapshotOperationCallable = callableFactory.createOperationCallable(createSnapshotTransportSettings, settings.createSnapshotOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.removeResourcePoliciesCallable = callableFactory.createUnaryCallable(removeResourcePoliciesTransportSettings, settings.removeResourcePoliciesSettings(), clientContext);
        this.removeResourcePoliciesOperationCallable = callableFactory.createOperationCallable(removeResourcePoliciesTransportSettings, settings.removeResourcePoliciesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.resizeCallable = callableFactory.createUnaryCallable(resizeTransportSettings, settings.resizeSettings(), clientContext);
        this.resizeOperationCallable = callableFactory.createOperationCallable(resizeTransportSettings, settings.resizeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.setLabelsCallable = callableFactory.createUnaryCallable(setLabelsTransportSettings, settings.setLabelsSettings(), clientContext);
        this.setLabelsOperationCallable = callableFactory.createOperationCallable(setLabelsTransportSettings, settings.setLabelsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.updateCallable = callableFactory.createUnaryCallable(updateTransportSettings, settings.updateSettings(), clientContext);
        this.updateOperationCallable = callableFactory.createOperationCallable(updateTransportSettings, settings.updateOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(addResourcePoliciesMethodDescriptor);
        methodDescriptors.add(createSnapshotMethodDescriptor);
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(removeResourcePoliciesMethodDescriptor);
        methodDescriptors.add(resizeMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(setLabelsMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        methodDescriptors.add(updateMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesCallable() {
        return this.addResourcePoliciesCallable;
    }

    @Override
    public OperationCallable<AddResourcePoliciesRegionDiskRequest, Operation, Operation> addResourcePoliciesOperationCallable() {
        return this.addResourcePoliciesOperationCallable;
    }

    @Override
    public UnaryCallable<CreateSnapshotRegionDiskRequest, Operation> createSnapshotCallable() {
        return this.createSnapshotCallable;
    }

    @Override
    public OperationCallable<CreateSnapshotRegionDiskRequest, Operation, Operation> createSnapshotOperationCallable() {
        return this.createSnapshotOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRegionDiskRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteRegionDiskRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetRegionDiskRequest, Disk> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRegionDiskRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<InsertRegionDiskRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertRegionDiskRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListRegionDisksRequest, DiskList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListRegionDisksRequest, RegionDisksClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesCallable() {
        return this.removeResourcePoliciesCallable;
    }

    @Override
    public OperationCallable<RemoveResourcePoliciesRegionDiskRequest, Operation, Operation> removeResourcePoliciesOperationCallable() {
        return this.removeResourcePoliciesOperationCallable;
    }

    @Override
    public UnaryCallable<ResizeRegionDiskRequest, Operation> resizeCallable() {
        return this.resizeCallable;
    }

    @Override
    public OperationCallable<ResizeRegionDiskRequest, Operation, Operation> resizeOperationCallable() {
        return this.resizeOperationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRegionDiskRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetLabelsRegionDiskRequest, Operation> setLabelsCallable() {
        return this.setLabelsCallable;
    }

    @Override
    public OperationCallable<SetLabelsRegionDiskRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.setLabelsOperationCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public UnaryCallable<UpdateRegionDiskRequest, Operation> updateCallable() {
        return this.updateCallable;
    }

    @Override
    public OperationCallable<UpdateRegionDiskRequest, Operation, Operation> updateOperationCallable() {
        return this.updateOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

