/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesRegionDiskRequest;
import com.google.cloud.compute.v1.CreateSnapshotRegionDiskRequest;
import com.google.cloud.compute.v1.DeleteRegionDiskRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.GetIamPolicyRegionDiskRequest;
import com.google.cloud.compute.v1.GetRegionDiskRequest;
import com.google.cloud.compute.v1.InsertRegionDiskRequest;
import com.google.cloud.compute.v1.ListRegionDisksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionDisksClient;
import com.google.cloud.compute.v1.RemoveResourcePoliciesRegionDiskRequest;
import com.google.cloud.compute.v1.ResizeRegionDiskRequest;
import com.google.cloud.compute.v1.SetIamPolicyRegionDiskRequest;
import com.google.cloud.compute.v1.SetLabelsRegionDiskRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionDiskRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateRegionDiskRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionDisksStub;
import com.google.cloud.compute.v1.stub.RegionDisksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionDisksStubSettings
extends StubSettings<RegionDisksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesSettings;
    private final OperationCallSettings<AddResourcePoliciesRegionDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings;
    private final UnaryCallSettings<CreateSnapshotRegionDiskRequest, Operation> createSnapshotSettings;
    private final OperationCallSettings<CreateSnapshotRegionDiskRequest, Operation, Operation> createSnapshotOperationSettings;
    private final UnaryCallSettings<DeleteRegionDiskRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionDiskRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetRegionDiskRequest, Disk> getSettings;
    private final UnaryCallSettings<GetIamPolicyRegionDiskRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertRegionDiskRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionDiskRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionDisksRequest, DiskList, RegionDisksClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesSettings;
    private final OperationCallSettings<RemoveResourcePoliciesRegionDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings;
    private final UnaryCallSettings<ResizeRegionDiskRequest, Operation> resizeSettings;
    private final OperationCallSettings<ResizeRegionDiskRequest, Operation, Operation> resizeOperationSettings;
    private final UnaryCallSettings<SetIamPolicyRegionDiskRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetLabelsRegionDiskRequest, Operation> setLabelsSettings;
    private final OperationCallSettings<SetLabelsRegionDiskRequest, Operation, Operation> setLabelsOperationSettings;
    private final UnaryCallSettings<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateRegionDiskRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateRegionDiskRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<ListRegionDisksRequest, DiskList, Disk> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionDisksRequest, DiskList, Disk>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionDisksRequest injectToken(ListRegionDisksRequest payload, String token) {
            return ListRegionDisksRequest.newBuilder((ListRegionDisksRequest)payload).setPageToken(token).build();
        }

        public ListRegionDisksRequest injectPageSize(ListRegionDisksRequest payload, int pageSize) {
            return ListRegionDisksRequest.newBuilder((ListRegionDisksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionDisksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Disk> extractResources(DiskList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionDisksRequest, DiskList, RegionDisksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionDisksRequest, DiskList, RegionDisksClient.ListPagedResponse>(){

        public ApiFuture<RegionDisksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionDisksRequest, DiskList> callable, ListRegionDisksRequest request, ApiCallContext context, ApiFuture<DiskList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionDisksClient.ListPagedResponse.createAsync((PageContext<ListRegionDisksRequest, DiskList, Disk>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesSettings() {
        return this.addResourcePoliciesSettings;
    }

    public OperationCallSettings<AddResourcePoliciesRegionDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings() {
        return this.addResourcePoliciesOperationSettings;
    }

    public UnaryCallSettings<CreateSnapshotRegionDiskRequest, Operation> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public OperationCallSettings<CreateSnapshotRegionDiskRequest, Operation, Operation> createSnapshotOperationSettings() {
        return this.createSnapshotOperationSettings;
    }

    public UnaryCallSettings<DeleteRegionDiskRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionDiskRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetRegionDiskRequest, Disk> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyRegionDiskRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertRegionDiskRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionDiskRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionDisksRequest, DiskList, RegionDisksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesSettings() {
        return this.removeResourcePoliciesSettings;
    }

    public OperationCallSettings<RemoveResourcePoliciesRegionDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings() {
        return this.removeResourcePoliciesOperationSettings;
    }

    public UnaryCallSettings<ResizeRegionDiskRequest, Operation> resizeSettings() {
        return this.resizeSettings;
    }

    public OperationCallSettings<ResizeRegionDiskRequest, Operation, Operation> resizeOperationSettings() {
        return this.resizeOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRegionDiskRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetLabelsRegionDiskRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public OperationCallSettings<SetLabelsRegionDiskRequest, Operation, Operation> setLabelsOperationSettings() {
        return this.setLabelsOperationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateRegionDiskRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateRegionDiskRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public RegionDisksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionDisksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionDisksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionDisksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionDisksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addResourcePoliciesSettings = settingsBuilder.addResourcePoliciesSettings().build();
        this.addResourcePoliciesOperationSettings = settingsBuilder.addResourcePoliciesOperationSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.createSnapshotOperationSettings = settingsBuilder.createSnapshotOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.removeResourcePoliciesSettings = settingsBuilder.removeResourcePoliciesSettings().build();
        this.removeResourcePoliciesOperationSettings = settingsBuilder.removeResourcePoliciesOperationSettings().build();
        this.resizeSettings = settingsBuilder.resizeSettings().build();
        this.resizeOperationSettings = settingsBuilder.resizeOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setLabelsOperationSettings = settingsBuilder.setLabelsOperationSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionDisksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesSettings;
        private final OperationCallSettings.Builder<AddResourcePoliciesRegionDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotRegionDiskRequest, Operation> createSnapshotSettings;
        private final OperationCallSettings.Builder<CreateSnapshotRegionDiskRequest, Operation, Operation> createSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRegionDiskRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionDiskRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionDiskRequest, Disk> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRegionDiskRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertRegionDiskRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionDiskRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionDisksRequest, DiskList, RegionDisksClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesSettings;
        private final OperationCallSettings.Builder<RemoveResourcePoliciesRegionDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings;
        private final UnaryCallSettings.Builder<ResizeRegionDiskRequest, Operation> resizeSettings;
        private final OperationCallSettings.Builder<ResizeRegionDiskRequest, Operation, Operation> resizeOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRegionDiskRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetLabelsRegionDiskRequest, Operation> setLabelsSettings;
        private final OperationCallSettings.Builder<SetLabelsRegionDiskRequest, Operation, Operation> setLabelsOperationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateRegionDiskRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateRegionDiskRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addResourcePoliciesOperationSettings = OperationCallSettings.newBuilder();
            this.createSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.removeResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeResourcePoliciesOperationSettings = OperationCallSettings.newBuilder();
            this.resizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsOperationSettings = OperationCallSettings.newBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addResourcePoliciesSettings, this.createSnapshotSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.removeResourcePoliciesSettings, this.resizeSettings, this.setIamPolicySettings, this.setLabelsSettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RegionDisksStubSettings settings) {
            super((StubSettings)settings);
            this.addResourcePoliciesSettings = settings.addResourcePoliciesSettings.toBuilder();
            this.addResourcePoliciesOperationSettings = settings.addResourcePoliciesOperationSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.createSnapshotOperationSettings = settings.createSnapshotOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.removeResourcePoliciesSettings = settings.removeResourcePoliciesSettings.toBuilder();
            this.removeResourcePoliciesOperationSettings = settings.removeResourcePoliciesOperationSettings.toBuilder();
            this.resizeSettings = settings.resizeSettings.toBuilder();
            this.resizeOperationSettings = settings.resizeOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setLabelsOperationSettings = settings.setLabelsOperationSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addResourcePoliciesSettings, this.createSnapshotSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.removeResourcePoliciesSettings, this.resizeSettings, this.setIamPolicySettings, this.setLabelsSettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionDisksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionDisksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionDisksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionDisksStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RegionDisksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.removeResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addResourcePoliciesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.createSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeResourcePoliciesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.resizeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setLabelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesSettings() {
            return this.addResourcePoliciesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddResourcePoliciesRegionDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings() {
            return this.addResourcePoliciesOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotRegionDiskRequest, Operation> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSnapshotRegionDiskRequest, Operation, Operation> createSnapshotOperationSettings() {
            return this.createSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegionDiskRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRegionDiskRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionDiskRequest, Disk> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRegionDiskRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertRegionDiskRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertRegionDiskRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionDisksRequest, DiskList, RegionDisksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesSettings() {
            return this.removeResourcePoliciesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RemoveResourcePoliciesRegionDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings() {
            return this.removeResourcePoliciesOperationSettings;
        }

        public UnaryCallSettings.Builder<ResizeRegionDiskRequest, Operation> resizeSettings() {
            return this.resizeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResizeRegionDiskRequest, Operation, Operation> resizeOperationSettings() {
            return this.resizeOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRegionDiskRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetLabelsRegionDiskRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetLabelsRegionDiskRequest, Operation, Operation> setLabelsOperationSettings() {
            return this.setLabelsOperationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionDiskRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateRegionDiskRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public RegionDisksStubSettings build() throws IOException {
            return new RegionDisksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

