/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.AddResourcePoliciesInstanceRequest;
import com.google.cloud.compute.v1.AggregatedListInstancesRequest;
import com.google.cloud.compute.v1.AttachDiskInstanceRequest;
import com.google.cloud.compute.v1.BulkInsertInstanceRequest;
import com.google.cloud.compute.v1.DeleteAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.DeleteInstanceRequest;
import com.google.cloud.compute.v1.DetachDiskInstanceRequest;
import com.google.cloud.compute.v1.GetEffectiveFirewallsInstanceRequest;
import com.google.cloud.compute.v1.GetGuestAttributesInstanceRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstanceRequest;
import com.google.cloud.compute.v1.GetInstanceRequest;
import com.google.cloud.compute.v1.GetScreenshotInstanceRequest;
import com.google.cloud.compute.v1.GetSerialPortOutputInstanceRequest;
import com.google.cloud.compute.v1.GetShieldedInstanceIdentityInstanceRequest;
import com.google.cloud.compute.v1.GuestAttributes;
import com.google.cloud.compute.v1.InsertInstanceRequest;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceAggregatedList;
import com.google.cloud.compute.v1.InstanceList;
import com.google.cloud.compute.v1.InstanceListReferrers;
import com.google.cloud.compute.v1.InstancesClient;
import com.google.cloud.compute.v1.InstancesGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.InstancesScopedList;
import com.google.cloud.compute.v1.ListInstancesRequest;
import com.google.cloud.compute.v1.ListReferrersInstancesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.Reference;
import com.google.cloud.compute.v1.RemoveResourcePoliciesInstanceRequest;
import com.google.cloud.compute.v1.ResetInstanceRequest;
import com.google.cloud.compute.v1.Screenshot;
import com.google.cloud.compute.v1.SerialPortOutput;
import com.google.cloud.compute.v1.SetDeletionProtectionInstanceRequest;
import com.google.cloud.compute.v1.SetDiskAutoDeleteInstanceRequest;
import com.google.cloud.compute.v1.SetIamPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetLabelsInstanceRequest;
import com.google.cloud.compute.v1.SetMachineResourcesInstanceRequest;
import com.google.cloud.compute.v1.SetMachineTypeInstanceRequest;
import com.google.cloud.compute.v1.SetMetadataInstanceRequest;
import com.google.cloud.compute.v1.SetMinCpuPlatformInstanceRequest;
import com.google.cloud.compute.v1.SetSchedulingInstanceRequest;
import com.google.cloud.compute.v1.SetServiceAccountInstanceRequest;
import com.google.cloud.compute.v1.SetShieldedInstanceIntegrityPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetTagsInstanceRequest;
import com.google.cloud.compute.v1.ShieldedInstanceIdentity;
import com.google.cloud.compute.v1.SimulateMaintenanceEventInstanceRequest;
import com.google.cloud.compute.v1.StartInstanceRequest;
import com.google.cloud.compute.v1.StartWithEncryptionKeyInstanceRequest;
import com.google.cloud.compute.v1.StopInstanceRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInstanceRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.UpdateDisplayDeviceInstanceRequest;
import com.google.cloud.compute.v1.UpdateInstanceRequest;
import com.google.cloud.compute.v1.UpdateNetworkInterfaceInstanceRequest;
import com.google.cloud.compute.v1.UpdateShieldedInstanceConfigInstanceRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstancesStub;
import com.google.cloud.compute.v1.stub.InstancesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InstancesStubSettings
extends StubSettings<InstancesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").build();
    private final UnaryCallSettings<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings;
    private final UnaryCallSettings<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings;
    private final PagedCallSettings<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<AttachDiskInstanceRequest, Operation> attachDiskSettings;
    private final UnaryCallSettings<BulkInsertInstanceRequest, Operation> bulkInsertSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteSettings;
    private final UnaryCallSettings<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings;
    private final UnaryCallSettings<DetachDiskInstanceRequest, Operation> detachDiskSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getSettings;
    private final UnaryCallSettings<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
    private final UnaryCallSettings<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings;
    private final UnaryCallSettings<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings;
    private final UnaryCallSettings<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings;
    private final UnaryCallSettings<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings;
    private final UnaryCallSettings<InsertInstanceRequest, Operation> insertSettings;
    private final PagedCallSettings<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings;
    private final UnaryCallSettings<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings;
    private final UnaryCallSettings<ResetInstanceRequest, Operation> resetSettings;
    private final UnaryCallSettings<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings;
    private final UnaryCallSettings<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings;
    private final UnaryCallSettings<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetLabelsInstanceRequest, Operation> setLabelsSettings;
    private final UnaryCallSettings<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings;
    private final UnaryCallSettings<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings;
    private final UnaryCallSettings<SetMetadataInstanceRequest, Operation> setMetadataSettings;
    private final UnaryCallSettings<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings;
    private final UnaryCallSettings<SetSchedulingInstanceRequest, Operation> setSchedulingSettings;
    private final UnaryCallSettings<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings;
    private final UnaryCallSettings<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings;
    private final UnaryCallSettings<SetTagsInstanceRequest, Operation> setTagsSettings;
    private final UnaryCallSettings<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings;
    private final UnaryCallSettings<StartInstanceRequest, Operation> startSettings;
    private final UnaryCallSettings<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings;
    private final UnaryCallSettings<StopInstanceRequest, Operation> stopSettings;
    private final UnaryCallSettings<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateSettings;
    private final UnaryCallSettings<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings;
    private final UnaryCallSettings<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings;
    private final UnaryCallSettings<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings;
    private final UnaryCallSettings<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings;
    private static final PagedListDescriptor<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstancesRequest injectToken(AggregatedListInstancesRequest payload, String token) {
            return AggregatedListInstancesRequest.newBuilder((AggregatedListInstancesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListInstancesRequest injectPageSize(AggregatedListInstancesRequest payload, int pageSize) {
            return AggregatedListInstancesRequest.newBuilder((AggregatedListInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, InstancesScopedList>> extractResources(InstanceAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().entrySet() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListInstancesRequest, InstanceList, Instance> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, InstanceList, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(InstanceList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListReferrersInstancesRequest, InstanceListReferrers, Reference> LIST_REFERRERS_PAGE_STR_DESC = new PagedListDescriptor<ListReferrersInstancesRequest, InstanceListReferrers, Reference>(){

        public String emptyToken() {
            return "";
        }

        public ListReferrersInstancesRequest injectToken(ListReferrersInstancesRequest payload, String token) {
            return ListReferrersInstancesRequest.newBuilder((ListReferrersInstancesRequest)payload).setPageToken(token).build();
        }

        public ListReferrersInstancesRequest injectPageSize(ListReferrersInstancesRequest payload, int pageSize) {
            return ListReferrersInstancesRequest.newBuilder((ListReferrersInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReferrersInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceListReferrers payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reference> extractResources(InstanceListReferrers payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse>(){

        public ApiFuture<InstancesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstancesRequest, InstanceAggregatedList> callable, AggregatedListInstancesRequest request, ApiCallContext context, ApiFuture<InstanceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstancesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse>(){

        public ApiFuture<InstancesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, InstanceList> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<InstanceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstancesClient.ListPagedResponse.createAsync((PageContext<ListInstancesRequest, InstanceList, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> LIST_REFERRERS_PAGE_STR_FACT = new PagedListResponseFactory<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse>(){

        public ApiFuture<InstancesClient.ListReferrersPagedResponse> getFuturePagedResponse(UnaryCallable<ListReferrersInstancesRequest, InstanceListReferrers> callable, ListReferrersInstancesRequest request, ApiCallContext context, ApiFuture<InstanceListReferrers> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REFERRERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstancesClient.ListReferrersPagedResponse.createAsync((PageContext<ListReferrersInstancesRequest, InstanceListReferrers, Reference>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings() {
        return this.addAccessConfigSettings;
    }

    public UnaryCallSettings<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings() {
        return this.addResourcePoliciesSettings;
    }

    public PagedCallSettings<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<AttachDiskInstanceRequest, Operation> attachDiskSettings() {
        return this.attachDiskSettings;
    }

    public UnaryCallSettings<BulkInsertInstanceRequest, Operation> bulkInsertSettings() {
        return this.bulkInsertSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings() {
        return this.deleteAccessConfigSettings;
    }

    public UnaryCallSettings<DetachDiskInstanceRequest, Operation> detachDiskSettings() {
        return this.detachDiskSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
        return this.getEffectiveFirewallsSettings;
    }

    public UnaryCallSettings<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings() {
        return this.getGuestAttributesSettings;
    }

    public UnaryCallSettings<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings() {
        return this.getScreenshotSettings;
    }

    public UnaryCallSettings<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings() {
        return this.getSerialPortOutputSettings;
    }

    public UnaryCallSettings<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings() {
        return this.getShieldedInstanceIdentitySettings;
    }

    public UnaryCallSettings<InsertInstanceRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings() {
        return this.listReferrersSettings;
    }

    public UnaryCallSettings<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings() {
        return this.removeResourcePoliciesSettings;
    }

    public UnaryCallSettings<ResetInstanceRequest, Operation> resetSettings() {
        return this.resetSettings;
    }

    public UnaryCallSettings<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings() {
        return this.setDeletionProtectionSettings;
    }

    public UnaryCallSettings<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings() {
        return this.setDiskAutoDeleteSettings;
    }

    public UnaryCallSettings<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetLabelsInstanceRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public UnaryCallSettings<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings() {
        return this.setMachineResourcesSettings;
    }

    public UnaryCallSettings<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings() {
        return this.setMachineTypeSettings;
    }

    public UnaryCallSettings<SetMetadataInstanceRequest, Operation> setMetadataSettings() {
        return this.setMetadataSettings;
    }

    public UnaryCallSettings<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings() {
        return this.setMinCpuPlatformSettings;
    }

    public UnaryCallSettings<SetSchedulingInstanceRequest, Operation> setSchedulingSettings() {
        return this.setSchedulingSettings;
    }

    public UnaryCallSettings<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings() {
        return this.setServiceAccountSettings;
    }

    public UnaryCallSettings<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings() {
        return this.setShieldedInstanceIntegrityPolicySettings;
    }

    public UnaryCallSettings<SetTagsInstanceRequest, Operation> setTagsSettings() {
        return this.setTagsSettings;
    }

    public UnaryCallSettings<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings() {
        return this.simulateMaintenanceEventSettings;
    }

    public UnaryCallSettings<StartInstanceRequest, Operation> startSettings() {
        return this.startSettings;
    }

    public UnaryCallSettings<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings() {
        return this.startWithEncryptionKeySettings;
    }

    public UnaryCallSettings<StopInstanceRequest, Operation> stopSettings() {
        return this.stopSettings;
    }

    public UnaryCallSettings<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public UnaryCallSettings<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings() {
        return this.updateAccessConfigSettings;
    }

    public UnaryCallSettings<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings() {
        return this.updateDisplayDeviceSettings;
    }

    public UnaryCallSettings<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings() {
        return this.updateNetworkInterfaceSettings;
    }

    public UnaryCallSettings<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings() {
        return this.updateShieldedInstanceConfigSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstancesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstancesStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstancesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstancesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstancesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAccessConfigSettings = settingsBuilder.addAccessConfigSettings().build();
        this.addResourcePoliciesSettings = settingsBuilder.addResourcePoliciesSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.attachDiskSettings = settingsBuilder.attachDiskSettings().build();
        this.bulkInsertSettings = settingsBuilder.bulkInsertSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteAccessConfigSettings = settingsBuilder.deleteAccessConfigSettings().build();
        this.detachDiskSettings = settingsBuilder.detachDiskSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getEffectiveFirewallsSettings = settingsBuilder.getEffectiveFirewallsSettings().build();
        this.getGuestAttributesSettings = settingsBuilder.getGuestAttributesSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getScreenshotSettings = settingsBuilder.getScreenshotSettings().build();
        this.getSerialPortOutputSettings = settingsBuilder.getSerialPortOutputSettings().build();
        this.getShieldedInstanceIdentitySettings = settingsBuilder.getShieldedInstanceIdentitySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listReferrersSettings = settingsBuilder.listReferrersSettings().build();
        this.removeResourcePoliciesSettings = settingsBuilder.removeResourcePoliciesSettings().build();
        this.resetSettings = settingsBuilder.resetSettings().build();
        this.setDeletionProtectionSettings = settingsBuilder.setDeletionProtectionSettings().build();
        this.setDiskAutoDeleteSettings = settingsBuilder.setDiskAutoDeleteSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setMachineResourcesSettings = settingsBuilder.setMachineResourcesSettings().build();
        this.setMachineTypeSettings = settingsBuilder.setMachineTypeSettings().build();
        this.setMetadataSettings = settingsBuilder.setMetadataSettings().build();
        this.setMinCpuPlatformSettings = settingsBuilder.setMinCpuPlatformSettings().build();
        this.setSchedulingSettings = settingsBuilder.setSchedulingSettings().build();
        this.setServiceAccountSettings = settingsBuilder.setServiceAccountSettings().build();
        this.setShieldedInstanceIntegrityPolicySettings = settingsBuilder.setShieldedInstanceIntegrityPolicySettings().build();
        this.setTagsSettings = settingsBuilder.setTagsSettings().build();
        this.simulateMaintenanceEventSettings = settingsBuilder.simulateMaintenanceEventSettings().build();
        this.startSettings = settingsBuilder.startSettings().build();
        this.startWithEncryptionKeySettings = settingsBuilder.startWithEncryptionKeySettings().build();
        this.stopSettings = settingsBuilder.stopSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateAccessConfigSettings = settingsBuilder.updateAccessConfigSettings().build();
        this.updateDisplayDeviceSettings = settingsBuilder.updateDisplayDeviceSettings().build();
        this.updateNetworkInterfaceSettings = settingsBuilder.updateNetworkInterfaceSettings().build();
        this.updateShieldedInstanceConfigSettings = settingsBuilder.updateShieldedInstanceConfigSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstancesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings;
        private final UnaryCallSettings.Builder<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings;
        private final PagedCallSettings.Builder<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<AttachDiskInstanceRequest, Operation> attachDiskSettings;
        private final UnaryCallSettings.Builder<BulkInsertInstanceRequest, Operation> bulkInsertSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings;
        private final UnaryCallSettings.Builder<DetachDiskInstanceRequest, Operation> detachDiskSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getSettings;
        private final UnaryCallSettings.Builder<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
        private final UnaryCallSettings.Builder<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings;
        private final UnaryCallSettings.Builder<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings;
        private final UnaryCallSettings.Builder<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings;
        private final UnaryCallSettings.Builder<InsertInstanceRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings;
        private final UnaryCallSettings.Builder<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings;
        private final UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetSettings;
        private final UnaryCallSettings.Builder<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings;
        private final UnaryCallSettings.Builder<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetLabelsInstanceRequest, Operation> setLabelsSettings;
        private final UnaryCallSettings.Builder<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings;
        private final UnaryCallSettings.Builder<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings;
        private final UnaryCallSettings.Builder<SetMetadataInstanceRequest, Operation> setMetadataSettings;
        private final UnaryCallSettings.Builder<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings;
        private final UnaryCallSettings.Builder<SetSchedulingInstanceRequest, Operation> setSchedulingSettings;
        private final UnaryCallSettings.Builder<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings;
        private final UnaryCallSettings.Builder<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings;
        private final UnaryCallSettings.Builder<SetTagsInstanceRequest, Operation> setTagsSettings;
        private final UnaryCallSettings.Builder<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings;
        private final UnaryCallSettings.Builder<StartInstanceRequest, Operation> startSettings;
        private final UnaryCallSettings.Builder<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings;
        private final UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateSettings;
        private final UnaryCallSettings.Builder<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings;
        private final UnaryCallSettings.Builder<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings;
        private final UnaryCallSettings.Builder<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings;
        private final UnaryCallSettings.Builder<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAccessConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.attachDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.bulkInsertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccessConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEffectiveFirewallsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGuestAttributesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getScreenshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSerialPortOutputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getShieldedInstanceIdentitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listReferrersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REFERRERS_PAGE_STR_FACT);
            this.removeResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDeletionProtectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDiskAutoDeleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMachineResourcesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMachineTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMinCpuPlatformSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSchedulingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setShieldedInstanceIntegrityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTagsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.simulateMaintenanceEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startWithEncryptionKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccessConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDisplayDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNetworkInterfaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateShieldedInstanceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAccessConfigSettings, this.addResourcePoliciesSettings, this.aggregatedListSettings, this.attachDiskSettings, this.bulkInsertSettings, this.deleteSettings, this.deleteAccessConfigSettings, this.detachDiskSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.getGuestAttributesSettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.getScreenshotSettings, this.getSerialPortOutputSettings, this.getShieldedInstanceIdentitySettings, this.insertSettings, this.listSettings, this.listReferrersSettings, this.removeResourcePoliciesSettings, this.resetSettings, this.setDeletionProtectionSettings, this.setDiskAutoDeleteSettings, this.setIamPolicySettings, this.setLabelsSettings, this.setMachineResourcesSettings, this.setMachineTypeSettings, this.setMetadataSettings, this.setMinCpuPlatformSettings, this.setSchedulingSettings, this.setServiceAccountSettings, this.setShieldedInstanceIntegrityPolicySettings, this.setTagsSettings, this.simulateMaintenanceEventSettings, this.startSettings, this.startWithEncryptionKeySettings, this.stopSettings, this.testIamPermissionsSettings, this.updateSettings, this.updateAccessConfigSettings, this.updateDisplayDeviceSettings, this.updateNetworkInterfaceSettings, this.updateShieldedInstanceConfigSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstancesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstancesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstancesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InstancesStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAccessConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.addResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.attachDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.bulkInsertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteAccessConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.detachDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getEffectiveFirewallsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGuestAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getScreenshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSerialPortOutputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getShieldedInstanceIdentitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listReferrersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removeResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setDeletionProtectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setDiskAutoDeleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMachineResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMachineTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMinCpuPlatformSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSchedulingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setShieldedInstanceIntegrityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setTagsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.simulateMaintenanceEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.startSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.startWithEncryptionKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.stopSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateAccessConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateDisplayDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateNetworkInterfaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateShieldedInstanceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InstancesStubSettings settings) {
            super((StubSettings)settings);
            this.addAccessConfigSettings = settings.addAccessConfigSettings.toBuilder();
            this.addResourcePoliciesSettings = settings.addResourcePoliciesSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.attachDiskSettings = settings.attachDiskSettings.toBuilder();
            this.bulkInsertSettings = settings.bulkInsertSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteAccessConfigSettings = settings.deleteAccessConfigSettings.toBuilder();
            this.detachDiskSettings = settings.detachDiskSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getEffectiveFirewallsSettings = settings.getEffectiveFirewallsSettings.toBuilder();
            this.getGuestAttributesSettings = settings.getGuestAttributesSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getScreenshotSettings = settings.getScreenshotSettings.toBuilder();
            this.getSerialPortOutputSettings = settings.getSerialPortOutputSettings.toBuilder();
            this.getShieldedInstanceIdentitySettings = settings.getShieldedInstanceIdentitySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listReferrersSettings = settings.listReferrersSettings.toBuilder();
            this.removeResourcePoliciesSettings = settings.removeResourcePoliciesSettings.toBuilder();
            this.resetSettings = settings.resetSettings.toBuilder();
            this.setDeletionProtectionSettings = settings.setDeletionProtectionSettings.toBuilder();
            this.setDiskAutoDeleteSettings = settings.setDiskAutoDeleteSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setMachineResourcesSettings = settings.setMachineResourcesSettings.toBuilder();
            this.setMachineTypeSettings = settings.setMachineTypeSettings.toBuilder();
            this.setMetadataSettings = settings.setMetadataSettings.toBuilder();
            this.setMinCpuPlatformSettings = settings.setMinCpuPlatformSettings.toBuilder();
            this.setSchedulingSettings = settings.setSchedulingSettings.toBuilder();
            this.setServiceAccountSettings = settings.setServiceAccountSettings.toBuilder();
            this.setShieldedInstanceIntegrityPolicySettings = settings.setShieldedInstanceIntegrityPolicySettings.toBuilder();
            this.setTagsSettings = settings.setTagsSettings.toBuilder();
            this.simulateMaintenanceEventSettings = settings.simulateMaintenanceEventSettings.toBuilder();
            this.startSettings = settings.startSettings.toBuilder();
            this.startWithEncryptionKeySettings = settings.startWithEncryptionKeySettings.toBuilder();
            this.stopSettings = settings.stopSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateAccessConfigSettings = settings.updateAccessConfigSettings.toBuilder();
            this.updateDisplayDeviceSettings = settings.updateDisplayDeviceSettings.toBuilder();
            this.updateNetworkInterfaceSettings = settings.updateNetworkInterfaceSettings.toBuilder();
            this.updateShieldedInstanceConfigSettings = settings.updateShieldedInstanceConfigSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAccessConfigSettings, this.addResourcePoliciesSettings, this.aggregatedListSettings, this.attachDiskSettings, this.bulkInsertSettings, this.deleteSettings, this.deleteAccessConfigSettings, this.detachDiskSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.getGuestAttributesSettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.getScreenshotSettings, this.getSerialPortOutputSettings, this.getShieldedInstanceIdentitySettings, this.insertSettings, this.listSettings, this.listReferrersSettings, this.removeResourcePoliciesSettings, this.resetSettings, this.setDeletionProtectionSettings, this.setDiskAutoDeleteSettings, this.setIamPolicySettings, this.setLabelsSettings, this.setMachineResourcesSettings, this.setMachineTypeSettings, this.setMetadataSettings, this.setMinCpuPlatformSettings, this.setSchedulingSettings, this.setServiceAccountSettings, this.setShieldedInstanceIntegrityPolicySettings, this.setTagsSettings, this.simulateMaintenanceEventSettings, this.startSettings, this.startWithEncryptionKeySettings, this.stopSettings, this.testIamPermissionsSettings, this.updateSettings, this.updateAccessConfigSettings, this.updateDisplayDeviceSettings, this.updateNetworkInterfaceSettings, this.updateShieldedInstanceConfigSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings() {
            return this.addAccessConfigSettings;
        }

        public UnaryCallSettings.Builder<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings() {
            return this.addResourcePoliciesSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<AttachDiskInstanceRequest, Operation> attachDiskSettings() {
            return this.attachDiskSettings;
        }

        public UnaryCallSettings.Builder<BulkInsertInstanceRequest, Operation> bulkInsertSettings() {
            return this.bulkInsertSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings() {
            return this.deleteAccessConfigSettings;
        }

        public UnaryCallSettings.Builder<DetachDiskInstanceRequest, Operation> detachDiskSettings() {
            return this.detachDiskSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
            return this.getEffectiveFirewallsSettings;
        }

        public UnaryCallSettings.Builder<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings() {
            return this.getGuestAttributesSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings() {
            return this.getScreenshotSettings;
        }

        public UnaryCallSettings.Builder<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings() {
            return this.getSerialPortOutputSettings;
        }

        public UnaryCallSettings.Builder<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings() {
            return this.getShieldedInstanceIdentitySettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings() {
            return this.listReferrersSettings;
        }

        public UnaryCallSettings.Builder<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings() {
            return this.removeResourcePoliciesSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetSettings() {
            return this.resetSettings;
        }

        public UnaryCallSettings.Builder<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings() {
            return this.setDeletionProtectionSettings;
        }

        public UnaryCallSettings.Builder<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings() {
            return this.setDiskAutoDeleteSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetLabelsInstanceRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        public UnaryCallSettings.Builder<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings() {
            return this.setMachineResourcesSettings;
        }

        public UnaryCallSettings.Builder<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings() {
            return this.setMachineTypeSettings;
        }

        public UnaryCallSettings.Builder<SetMetadataInstanceRequest, Operation> setMetadataSettings() {
            return this.setMetadataSettings;
        }

        public UnaryCallSettings.Builder<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings() {
            return this.setMinCpuPlatformSettings;
        }

        public UnaryCallSettings.Builder<SetSchedulingInstanceRequest, Operation> setSchedulingSettings() {
            return this.setSchedulingSettings;
        }

        public UnaryCallSettings.Builder<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings() {
            return this.setServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings() {
            return this.setShieldedInstanceIntegrityPolicySettings;
        }

        public UnaryCallSettings.Builder<SetTagsInstanceRequest, Operation> setTagsSettings() {
            return this.setTagsSettings;
        }

        public UnaryCallSettings.Builder<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings() {
            return this.simulateMaintenanceEventSettings;
        }

        public UnaryCallSettings.Builder<StartInstanceRequest, Operation> startSettings() {
            return this.startSettings;
        }

        public UnaryCallSettings.Builder<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings() {
            return this.startWithEncryptionKeySettings;
        }

        public UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopSettings() {
            return this.stopSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings() {
            return this.updateAccessConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings() {
            return this.updateDisplayDeviceSettings;
        }

        public UnaryCallSettings.Builder<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings() {
            return this.updateNetworkInterfaceSettings;
        }

        public UnaryCallSettings.Builder<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings() {
            return this.updateShieldedInstanceConfigSettings;
        }

        public InstancesStubSettings build() throws IOException {
            return new InstancesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

