/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.GetRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.InsertRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.ListRegionNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionNetworkEndpointGroupsSettings;
import com.google.cloud.compute.v1.stub.RegionNetworkEndpointGroupsStub;
import com.google.cloud.compute.v1.stub.RegionNetworkEndpointGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionNetworkEndpointGroupsClient
implements BackgroundResource {
    private final RegionNetworkEndpointGroupsSettings settings;
    private final RegionNetworkEndpointGroupsStub stub;

    public static final RegionNetworkEndpointGroupsClient create() throws IOException {
        return RegionNetworkEndpointGroupsClient.create(RegionNetworkEndpointGroupsSettings.newBuilder().build());
    }

    public static final RegionNetworkEndpointGroupsClient create(RegionNetworkEndpointGroupsSettings settings) throws IOException {
        return new RegionNetworkEndpointGroupsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionNetworkEndpointGroupsClient create(RegionNetworkEndpointGroupsStub stub) {
        return new RegionNetworkEndpointGroupsClient(stub);
    }

    protected RegionNetworkEndpointGroupsClient(RegionNetworkEndpointGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionNetworkEndpointGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionNetworkEndpointGroupsClient(RegionNetworkEndpointGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionNetworkEndpointGroupsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionNetworkEndpointGroupsStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String region, String networkEndpointGroup) {
        DeleteRegionNetworkEndpointGroupRequest request = DeleteRegionNetworkEndpointGroupRequest.newBuilder().setProject(project).setRegion(region).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionNetworkEndpointGroupRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionNetworkEndpointGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final NetworkEndpointGroup get(String project, String region, String networkEndpointGroup) {
        GetRegionNetworkEndpointGroupRequest request = GetRegionNetworkEndpointGroupRequest.newBuilder().setProject(project).setRegion(region).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.get(request);
    }

    public final NetworkEndpointGroup get(GetRegionNetworkEndpointGroupRequest request) {
        return (NetworkEndpointGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionNetworkEndpointGroupRequest, NetworkEndpointGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertRegionNetworkEndpointGroupRequest request = InsertRegionNetworkEndpointGroupRequest.newBuilder().setProject(project).setRegion(region).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionNetworkEndpointGroupRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionNetworkEndpointGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionNetworkEndpointGroupsRequest request = ListRegionNetworkEndpointGroupsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionNetworkEndpointGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionNetworkEndpointGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage> {
        private ListPage(PageContext<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

