/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListPublicDelegatedPrefixesRequest;
import com.google.cloud.compute.v1.DeletePublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.GetPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.InsertPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.ListPublicDelegatedPrefixesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.PublicDelegatedPrefix;
import com.google.cloud.compute.v1.PublicDelegatedPrefixAggregatedList;
import com.google.cloud.compute.v1.PublicDelegatedPrefixList;
import com.google.cloud.compute.v1.PublicDelegatedPrefixesScopedList;
import com.google.cloud.compute.v1.PublicDelegatedPrefixesSettings;
import com.google.cloud.compute.v1.stub.PublicDelegatedPrefixesStub;
import com.google.cloud.compute.v1.stub.PublicDelegatedPrefixesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PublicDelegatedPrefixesClient
implements BackgroundResource {
    private final PublicDelegatedPrefixesSettings settings;
    private final PublicDelegatedPrefixesStub stub;

    public static final PublicDelegatedPrefixesClient create() throws IOException {
        return PublicDelegatedPrefixesClient.create(PublicDelegatedPrefixesSettings.newBuilder().build());
    }

    public static final PublicDelegatedPrefixesClient create(PublicDelegatedPrefixesSettings settings) throws IOException {
        return new PublicDelegatedPrefixesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PublicDelegatedPrefixesClient create(PublicDelegatedPrefixesStub stub) {
        return new PublicDelegatedPrefixesClient(stub);
    }

    protected PublicDelegatedPrefixesClient(PublicDelegatedPrefixesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PublicDelegatedPrefixesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PublicDelegatedPrefixesClient(PublicDelegatedPrefixesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PublicDelegatedPrefixesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PublicDelegatedPrefixesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListPublicDelegatedPrefixesRequest request = AggregatedListPublicDelegatedPrefixesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListPublicDelegatedPrefixesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListPublicDelegatedPrefixesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String publicDelegatedPrefix) {
        DeletePublicDelegatedPrefixeRequest request = DeletePublicDelegatedPrefixeRequest.newBuilder().setProject(project).setRegion(region).setPublicDelegatedPrefix(publicDelegatedPrefix).build();
        return this.delete(request);
    }

    public final Operation delete(DeletePublicDelegatedPrefixeRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePublicDelegatedPrefixeRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final PublicDelegatedPrefix get(String project, String region, String publicDelegatedPrefix) {
        GetPublicDelegatedPrefixeRequest request = GetPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setRegion(region).setPublicDelegatedPrefix(publicDelegatedPrefix).build();
        return this.get(request);
    }

    public final PublicDelegatedPrefix get(GetPublicDelegatedPrefixeRequest request) {
        return (PublicDelegatedPrefix)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetPublicDelegatedPrefixeRequest, PublicDelegatedPrefix> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, PublicDelegatedPrefix publicDelegatedPrefixResource) {
        InsertPublicDelegatedPrefixeRequest request = InsertPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setRegion(region).setPublicDelegatedPrefixResource(publicDelegatedPrefixResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertPublicDelegatedPrefixeRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertPublicDelegatedPrefixeRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListPublicDelegatedPrefixesRequest request = ListPublicDelegatedPrefixesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListPublicDelegatedPrefixesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPublicDelegatedPrefixesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, String publicDelegatedPrefix, PublicDelegatedPrefix publicDelegatedPrefixResource) {
        PatchPublicDelegatedPrefixeRequest request = PatchPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setRegion(region).setPublicDelegatedPrefix(publicDelegatedPrefix).setPublicDelegatedPrefixResource(publicDelegatedPrefixResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchPublicDelegatedPrefixeRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchPublicDelegatedPrefixeRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix, ListPage> {
        private ListPage(PageContext<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, PublicDelegatedPrefixList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, PublicDelegatedPrefixList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, ApiFuture<PublicDelegatedPrefixList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, ApiFuture<PublicDelegatedPrefixList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>> context, PublicDelegatedPrefixAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>> context, PublicDelegatedPrefixAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>> context, ApiFuture<PublicDelegatedPrefixAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>> context, ApiFuture<PublicDelegatedPrefixAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

