/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSslPoliciesRequest;
import com.google.cloud.compute.v1.DeleteSslPolicyRequest;
import com.google.cloud.compute.v1.GetSslPolicyRequest;
import com.google.cloud.compute.v1.InsertSslPolicyRequest;
import com.google.cloud.compute.v1.ListAvailableFeaturesSslPoliciesRequest;
import com.google.cloud.compute.v1.ListSslPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSslPolicyRequest;
import com.google.cloud.compute.v1.SslPoliciesAggregatedList;
import com.google.cloud.compute.v1.SslPoliciesClient;
import com.google.cloud.compute.v1.SslPoliciesList;
import com.google.cloud.compute.v1.SslPoliciesListAvailableFeaturesResponse;
import com.google.cloud.compute.v1.SslPoliciesScopedList;
import com.google.cloud.compute.v1.SslPolicy;
import com.google.cloud.compute.v1.stub.HttpJsonSslPoliciesStub;
import com.google.cloud.compute.v1.stub.SslPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class SslPoliciesStubSettings
extends StubSettings<SslPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, SslPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteSslPolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteSslPolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetSslPolicyRequest, SslPolicy> getSettings;
    private final UnaryCallSettings<InsertSslPolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertSslPolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListSslPoliciesRequest, SslPoliciesList, SslPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<ListAvailableFeaturesSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSettings;
    private final UnaryCallSettings<PatchSslPolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchSslPolicyRequest, Operation, Operation> patchOperationSettings;
    private static final PagedListDescriptor<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, Map.Entry<String, SslPoliciesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, Map.Entry<String, SslPoliciesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListSslPoliciesRequest injectToken(AggregatedListSslPoliciesRequest payload, String token) {
            return AggregatedListSslPoliciesRequest.newBuilder((AggregatedListSslPoliciesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListSslPoliciesRequest injectPageSize(AggregatedListSslPoliciesRequest payload, int pageSize) {
            return AggregatedListSslPoliciesRequest.newBuilder((AggregatedListSslPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListSslPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SslPoliciesAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, SslPoliciesScopedList>> extractResources(SslPoliciesAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListSslPoliciesRequest, SslPoliciesList, SslPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListSslPoliciesRequest injectToken(ListSslPoliciesRequest payload, String token) {
            return ListSslPoliciesRequest.newBuilder((ListSslPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListSslPoliciesRequest injectPageSize(ListSslPoliciesRequest payload, int pageSize) {
            return ListSslPoliciesRequest.newBuilder((ListSslPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSslPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SslPoliciesList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SslPolicy> extractResources(SslPoliciesList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, SslPoliciesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, SslPoliciesClient.AggregatedListPagedResponse>(){

        public ApiFuture<SslPoliciesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList> callable, AggregatedListSslPoliciesRequest request, ApiCallContext context, ApiFuture<SslPoliciesAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SslPoliciesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, Map.Entry<String, SslPoliciesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSslPoliciesRequest, SslPoliciesList, SslPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListSslPoliciesRequest, SslPoliciesList, SslPoliciesClient.ListPagedResponse>(){

        public ApiFuture<SslPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListSslPoliciesRequest, SslPoliciesList> callable, ListSslPoliciesRequest request, ApiCallContext context, ApiFuture<SslPoliciesList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SslPoliciesClient.ListPagedResponse.createAsync((PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, SslPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteSslPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteSslPolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetSslPolicyRequest, SslPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertSslPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertSslPolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListSslPoliciesRequest, SslPoliciesList, SslPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<ListAvailableFeaturesSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSettings() {
        return this.listAvailableFeaturesSettings;
    }

    public UnaryCallSettings<PatchSslPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchSslPolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public SslPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSslPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SslPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SslPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SslPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listAvailableFeaturesSettings = settingsBuilder.listAvailableFeaturesSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SslPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, SslPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteSslPolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteSslPolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetSslPolicyRequest, SslPolicy> getSettings;
        private final UnaryCallSettings.Builder<InsertSslPolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertSslPolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListSslPoliciesRequest, SslPoliciesList, SslPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<ListAvailableFeaturesSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSettings;
        private final UnaryCallSettings.Builder<PatchSslPolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchSslPolicyRequest, Operation, Operation> patchOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listAvailableFeaturesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.listAvailableFeaturesSettings, this.patchSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SslPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listAvailableFeaturesSettings = settings.listAvailableFeaturesSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.listAvailableFeaturesSettings, this.patchSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SslPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SslPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SslPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SslPoliciesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SslPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAvailableFeaturesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListSslPoliciesRequest, SslPoliciesAggregatedList, SslPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteSslPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSslPolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSslPolicyRequest, SslPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertSslPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertSslPolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListSslPoliciesRequest, SslPoliciesList, SslPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<ListAvailableFeaturesSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSettings() {
            return this.listAvailableFeaturesSettings;
        }

        public UnaryCallSettings.Builder<PatchSslPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PatchSslPolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public SslPoliciesStubSettings build() throws IOException {
            return new SslPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

