/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.GetRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.InsertRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.ListRegionTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetTcpProxiesSettings;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.stub.RegionTargetTcpProxiesStub;
import com.google.cloud.compute.v1.stub.RegionTargetTcpProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionTargetTcpProxiesClient
implements BackgroundResource {
    private final RegionTargetTcpProxiesSettings settings;
    private final RegionTargetTcpProxiesStub stub;

    public static final RegionTargetTcpProxiesClient create() throws IOException {
        return RegionTargetTcpProxiesClient.create(RegionTargetTcpProxiesSettings.newBuilder().build());
    }

    public static final RegionTargetTcpProxiesClient create(RegionTargetTcpProxiesSettings settings) throws IOException {
        return new RegionTargetTcpProxiesClient(settings);
    }

    public static final RegionTargetTcpProxiesClient create(RegionTargetTcpProxiesStub stub) {
        return new RegionTargetTcpProxiesClient(stub);
    }

    protected RegionTargetTcpProxiesClient(RegionTargetTcpProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionTargetTcpProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionTargetTcpProxiesClient(RegionTargetTcpProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionTargetTcpProxiesSettings getSettings() {
        return this.settings;
    }

    public RegionTargetTcpProxiesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String targetTcpProxy) {
        DeleteRegionTargetTcpProxyRequest request = DeleteRegionTargetTcpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetTcpProxy(targetTcpProxy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionTargetTcpProxyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionTargetTcpProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetTcpProxy get(String project, String region, String targetTcpProxy) {
        GetRegionTargetTcpProxyRequest request = GetRegionTargetTcpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetTcpProxy(targetTcpProxy).build();
        return this.get(request);
    }

    public final TargetTcpProxy get(GetRegionTargetTcpProxyRequest request) {
        return (TargetTcpProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, TargetTcpProxy targetTcpProxyResource) {
        InsertRegionTargetTcpProxyRequest request = InsertRegionTargetTcpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetTcpProxyResource(targetTcpProxyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionTargetTcpProxyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionTargetTcpProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionTargetTcpProxiesRequest request = ListRegionTargetTcpProxiesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionTargetTcpProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionTargetTcpProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage> {
        private ListPage(PageContext<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

