/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListRegionSecurityPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.RegionSecurityPoliciesSettings;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.stub.RegionSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.RegionSecurityPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionSecurityPoliciesClient
implements BackgroundResource {
    private final RegionSecurityPoliciesSettings settings;
    private final RegionSecurityPoliciesStub stub;

    public static final RegionSecurityPoliciesClient create() throws IOException {
        return RegionSecurityPoliciesClient.create(RegionSecurityPoliciesSettings.newBuilder().build());
    }

    public static final RegionSecurityPoliciesClient create(RegionSecurityPoliciesSettings settings) throws IOException {
        return new RegionSecurityPoliciesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionSecurityPoliciesClient create(RegionSecurityPoliciesStub stub) {
        return new RegionSecurityPoliciesClient(stub);
    }

    protected RegionSecurityPoliciesClient(RegionSecurityPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionSecurityPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionSecurityPoliciesClient(RegionSecurityPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionSecurityPoliciesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionSecurityPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String securityPolicy) {
        DeleteRegionSecurityPolicyRequest request = DeleteRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionSecurityPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionSecurityPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionSecurityPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SecurityPolicy get(String project, String region, String securityPolicy) {
        GetRegionSecurityPolicyRequest request = GetRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).build();
        return this.get(request);
    }

    public final SecurityPolicy get(GetRegionSecurityPolicyRequest request) {
        return (SecurityPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionSecurityPolicyRequest, SecurityPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, SecurityPolicy securityPolicyResource) {
        InsertRegionSecurityPolicyRequest request = InsertRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicyResource(securityPolicyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionSecurityPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionSecurityPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionSecurityPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionSecurityPoliciesRequest request = ListRegionSecurityPoliciesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionSecurityPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionSecurityPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionSecurityPoliciesRequest, SecurityPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String securityPolicy, SecurityPolicy securityPolicyResource) {
        PatchRegionSecurityPolicyRequest request = PatchRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).setSecurityPolicyResource(securityPolicyResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionSecurityPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionSecurityPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionSecurityPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage> {
        private ListPage(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

