/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteImageRequest;
import com.google.cloud.compute.v1.DeprecateImageRequest;
import com.google.cloud.compute.v1.GetFromFamilyImageRequest;
import com.google.cloud.compute.v1.GetIamPolicyImageRequest;
import com.google.cloud.compute.v1.GetImageRequest;
import com.google.cloud.compute.v1.Image;
import com.google.cloud.compute.v1.ImageList;
import com.google.cloud.compute.v1.ImagesClient;
import com.google.cloud.compute.v1.InsertImageRequest;
import com.google.cloud.compute.v1.ListImagesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchImageRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyImageRequest;
import com.google.cloud.compute.v1.SetLabelsImageRequest;
import com.google.cloud.compute.v1.TestIamPermissionsImageRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonImagesStub;
import com.google.cloud.compute.v1.stub.ImagesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ImagesStubSettings
extends StubSettings<ImagesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").build();
    private final UnaryCallSettings<DeleteImageRequest, Operation> deleteSettings;
    private final UnaryCallSettings<DeprecateImageRequest, Operation> deprecateSettings;
    private final UnaryCallSettings<GetImageRequest, Image> getSettings;
    private final UnaryCallSettings<GetFromFamilyImageRequest, Image> getFromFamilySettings;
    private final UnaryCallSettings<GetIamPolicyImageRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertImageRequest, Operation> insertSettings;
    private final PagedCallSettings<ListImagesRequest, ImageList, ImagesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchImageRequest, Operation> patchSettings;
    private final UnaryCallSettings<SetIamPolicyImageRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetLabelsImageRequest, Operation> setLabelsSettings;
    private final UnaryCallSettings<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListImagesRequest, ImageList, Image> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListImagesRequest, ImageList, Image>(){

        public String emptyToken() {
            return "";
        }

        public ListImagesRequest injectToken(ListImagesRequest payload, String token) {
            return ListImagesRequest.newBuilder((ListImagesRequest)payload).setPageToken(token).build();
        }

        public ListImagesRequest injectPageSize(ListImagesRequest payload, int pageSize) {
            return ListImagesRequest.newBuilder((ListImagesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListImagesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ImageList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Image> extractResources(ImageList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListImagesRequest, ImageList, ImagesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListImagesRequest, ImageList, ImagesClient.ListPagedResponse>(){

        public ApiFuture<ImagesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListImagesRequest, ImageList> callable, ListImagesRequest request, ApiCallContext context, ApiFuture<ImageList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ImagesClient.ListPagedResponse.createAsync((PageContext<ListImagesRequest, ImageList, Image>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteImageRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<DeprecateImageRequest, Operation> deprecateSettings() {
        return this.deprecateSettings;
    }

    public UnaryCallSettings<GetImageRequest, Image> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetFromFamilyImageRequest, Image> getFromFamilySettings() {
        return this.getFromFamilySettings;
    }

    public UnaryCallSettings<GetIamPolicyImageRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertImageRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListImagesRequest, ImageList, ImagesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchImageRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public UnaryCallSettings<SetIamPolicyImageRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetLabelsImageRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public UnaryCallSettings<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ImagesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonImagesStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ImagesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ImagesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ImagesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deprecateSettings = settingsBuilder.deprecateSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getFromFamilySettings = settingsBuilder.getFromFamilySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ImagesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteImageRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<DeprecateImageRequest, Operation> deprecateSettings;
        private final UnaryCallSettings.Builder<GetImageRequest, Image> getSettings;
        private final UnaryCallSettings.Builder<GetFromFamilyImageRequest, Image> getFromFamilySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyImageRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertImageRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListImagesRequest, ImageList, ImagesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchImageRequest, Operation> patchSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyImageRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetLabelsImageRequest, Operation> setLabelsSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deprecateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFromFamilySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.deprecateSettings, this.getSettings, this.getFromFamilySettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.patchSettings, this.setIamPolicySettings, this.setLabelsSettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ImagesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ImagesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ImagesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ImagesStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deprecateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getFromFamilySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ImagesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deprecateSettings = settings.deprecateSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getFromFamilySettings = settings.getFromFamilySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.deprecateSettings, this.getSettings, this.getFromFamilySettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.patchSettings, this.setIamPolicySettings, this.setLabelsSettings, this.testIamPermissionsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteImageRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<DeprecateImageRequest, Operation> deprecateSettings() {
            return this.deprecateSettings;
        }

        public UnaryCallSettings.Builder<GetImageRequest, Image> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetFromFamilyImageRequest, Image> getFromFamilySettings() {
            return this.getFromFamilySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyImageRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertImageRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListImagesRequest, ImageList, ImagesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchImageRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyImageRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetLabelsImageRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsImageRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ImagesStubSettings build() throws IOException {
            return new ImagesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

