/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetInstancesRequest;
import com.google.cloud.compute.v1.DeleteTargetInstanceRequest;
import com.google.cloud.compute.v1.GetTargetInstanceRequest;
import com.google.cloud.compute.v1.InsertTargetInstanceRequest;
import com.google.cloud.compute.v1.ListTargetInstancesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.TargetInstanceAggregatedList;
import com.google.cloud.compute.v1.TargetInstanceList;
import com.google.cloud.compute.v1.TargetInstancesClient;
import com.google.cloud.compute.v1.stub.HttpJsonTargetInstancesCallableFactory;
import com.google.cloud.compute.v1.stub.TargetInstancesStub;
import com.google.cloud.compute.v1.stub.TargetInstancesStubSettings;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonTargetInstancesStub
extends TargetInstancesStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList> aggregatedListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.TargetInstances.AggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/aggregated/targetInstances", (FieldsExtractor)new FieldsExtractor<AggregatedListTargetInstancesRequest, Map<String, String>>(){

        public Map<String, String> extract(AggregatedListTargetInstancesRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListTargetInstancesRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(AggregatedListTargetInstancesRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasIncludeAllScopes()) {
                serializer.putQueryParam(fields, "includeAllScopes", (Object)request.getIncludeAllScopes());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListTargetInstancesRequest, String>(){

        public String extract(AggregatedListTargetInstancesRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TargetInstanceAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteTargetInstanceRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.TargetInstances.Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/targetInstances/{targetInstance}", (FieldsExtractor)new FieldsExtractor<DeleteTargetInstanceRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteTargetInstanceRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "targetInstance", (Object)request.getTargetInstance());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteTargetInstanceRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteTargetInstanceRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteTargetInstanceRequest, String>(){

        public String extract(DeleteTargetInstanceRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetTargetInstanceRequest, TargetInstance> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.TargetInstances.Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/targetInstances/{targetInstance}", (FieldsExtractor)new FieldsExtractor<GetTargetInstanceRequest, Map<String, String>>(){

        public Map<String, String> extract(GetTargetInstanceRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "targetInstance", (Object)request.getTargetInstance());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetTargetInstanceRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetTargetInstanceRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetTargetInstanceRequest, String>(){

        public String extract(GetTargetInstanceRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TargetInstance.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertTargetInstanceRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.TargetInstances.Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/targetInstances", (FieldsExtractor)new FieldsExtractor<InsertTargetInstanceRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertTargetInstanceRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertTargetInstanceRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertTargetInstanceRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertTargetInstanceRequest, String>(){

        public String extract(InsertTargetInstanceRequest request) {
            return ProtoRestSerializer.create().toBody("targetInstanceResource", (Message)request.getTargetInstanceResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListTargetInstancesRequest, TargetInstanceList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.TargetInstances.List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/targetInstances", (FieldsExtractor)new FieldsExtractor<ListTargetInstancesRequest, Map<String, String>>(){

        public Map<String, String> extract(ListTargetInstancesRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListTargetInstancesRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListTargetInstancesRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListTargetInstancesRequest, String>(){

        public String extract(ListTargetInstancesRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TargetInstanceList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList> aggregatedListCallable;
    private final UnaryCallable<AggregatedListTargetInstancesRequest, TargetInstancesClient.AggregatedListPagedResponse> aggregatedListPagedCallable;
    private final UnaryCallable<DeleteTargetInstanceRequest, Operation> deleteCallable;
    private final UnaryCallable<GetTargetInstanceRequest, TargetInstance> getCallable;
    private final UnaryCallable<InsertTargetInstanceRequest, Operation> insertCallable;
    private final UnaryCallable<ListTargetInstancesRequest, TargetInstanceList> listCallable;
    private final UnaryCallable<ListTargetInstancesRequest, TargetInstancesClient.ListPagedResponse> listPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTargetInstancesStub create(TargetInstancesStubSettings settings) throws IOException {
        return new HttpJsonTargetInstancesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTargetInstancesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTargetInstancesStub(TargetInstancesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonTargetInstancesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTargetInstancesStub(TargetInstancesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTargetInstancesStub(TargetInstancesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTargetInstancesCallableFactory());
    }

    protected HttpJsonTargetInstancesStub(TargetInstancesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListMethodDescriptor).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        this.aggregatedListCallable = callableFactory.createUnaryCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.aggregatedListPagedCallable = callableFactory.createPagedCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<AggregatedListTargetInstancesRequest, TargetInstancesClient.AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.aggregatedListPagedCallable;
    }

    @Override
    public UnaryCallable<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList> aggregatedListCallable() {
        return this.aggregatedListCallable;
    }

    @Override
    public UnaryCallable<DeleteTargetInstanceRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetTargetInstanceRequest, TargetInstance> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertTargetInstanceRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListTargetInstancesRequest, TargetInstancesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListTargetInstancesRequest, TargetInstanceList> listCallable() {
        return this.listCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

