/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetTcpProxyRequest;
import com.google.cloud.compute.v1.GetTargetTcpProxyRequest;
import com.google.cloud.compute.v1.InsertTargetTcpProxyRequest;
import com.google.cloud.compute.v1.ListTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetTcpProxyRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetTcpProxyRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSetBackendServiceRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSetProxyHeaderRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSettings;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.stub.TargetTcpProxiesStub;
import com.google.cloud.compute.v1.stub.TargetTcpProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetTcpProxiesClient
implements BackgroundResource {
    private final TargetTcpProxiesSettings settings;
    private final TargetTcpProxiesStub stub;

    public static final TargetTcpProxiesClient create() throws IOException {
        return TargetTcpProxiesClient.create(TargetTcpProxiesSettings.newBuilder().build());
    }

    public static final TargetTcpProxiesClient create(TargetTcpProxiesSettings settings) throws IOException {
        return new TargetTcpProxiesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetTcpProxiesClient create(TargetTcpProxiesStub stub) {
        return new TargetTcpProxiesClient(stub);
    }

    protected TargetTcpProxiesClient(TargetTcpProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetTcpProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetTcpProxiesClient(TargetTcpProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetTcpProxiesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetTcpProxiesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String targetTcpProxy) {
        DeleteTargetTcpProxyRequest request = DeleteTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteTargetTcpProxyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTargetTcpProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetTcpProxy get(String project, String targetTcpProxy) {
        GetTargetTcpProxyRequest request = GetTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).build();
        return this.get(request);
    }

    public final TargetTcpProxy get(GetTargetTcpProxyRequest request) {
        return (TargetTcpProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetTcpProxyRequest, TargetTcpProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, TargetTcpProxy targetTcpProxyResource) {
        InsertTargetTcpProxyRequest request = InsertTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxyResource(targetTcpProxyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertTargetTcpProxyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertTargetTcpProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetTcpProxiesRequest request = ListTargetTcpProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetTcpProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetTcpProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetTcpProxiesRequest, TargetTcpProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation setBackendService(String project, String targetTcpProxy, TargetTcpProxiesSetBackendServiceRequest targetTcpProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetTcpProxyRequest request = SetBackendServiceTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).setTargetTcpProxiesSetBackendServiceRequestResource(targetTcpProxiesSetBackendServiceRequestResource).build();
        return this.setBackendService(request);
    }

    public final Operation setBackendService(SetBackendServiceTargetTcpProxyRequest request) {
        return (Operation)this.setBackendServiceCallable().call((Object)request);
    }

    public final UnaryCallable<SetBackendServiceTargetTcpProxyRequest, Operation> setBackendServiceCallable() {
        return this.stub.setBackendServiceCallable();
    }

    public final Operation setProxyHeader(String project, String targetTcpProxy, TargetTcpProxiesSetProxyHeaderRequest targetTcpProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetTcpProxyRequest request = SetProxyHeaderTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).setTargetTcpProxiesSetProxyHeaderRequestResource(targetTcpProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeader(request);
    }

    public final Operation setProxyHeader(SetProxyHeaderTargetTcpProxyRequest request) {
        return (Operation)this.setProxyHeaderCallable().call((Object)request);
    }

    public final UnaryCallable<SetProxyHeaderTargetTcpProxyRequest, Operation> setProxyHeaderCallable() {
        return this.stub.setProxyHeaderCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage> {
        private ListPage(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

