/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteSnapshotRequest;
import com.google.cloud.compute.v1.GetIamPolicySnapshotRequest;
import com.google.cloud.compute.v1.GetSnapshotRequest;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.ListSnapshotsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicySnapshotRequest;
import com.google.cloud.compute.v1.SetLabelsSnapshotRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.SnapshotList;
import com.google.cloud.compute.v1.SnapshotsSettings;
import com.google.cloud.compute.v1.TestIamPermissionsSnapshotRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.SnapshotsStub;
import com.google.cloud.compute.v1.stub.SnapshotsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SnapshotsClient
implements BackgroundResource {
    private final SnapshotsSettings settings;
    private final SnapshotsStub stub;

    public static final SnapshotsClient create() throws IOException {
        return SnapshotsClient.create(SnapshotsSettings.newBuilder().build());
    }

    public static final SnapshotsClient create(SnapshotsSettings settings) throws IOException {
        return new SnapshotsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SnapshotsClient create(SnapshotsStub stub) {
        return new SnapshotsClient(stub);
    }

    protected SnapshotsClient(SnapshotsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SnapshotsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SnapshotsClient(SnapshotsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SnapshotsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SnapshotsStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String snapshot) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setProject(project).setSnapshot(snapshot).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteSnapshotRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSnapshotRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Snapshot get(String project, String snapshot) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setProject(project).setSnapshot(snapshot).build();
        return this.get(request);
    }

    public final Snapshot get(GetSnapshotRequest request) {
        return (Snapshot)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnapshotRequest, Snapshot> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicySnapshotRequest request = GetIamPolicySnapshotRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicySnapshotRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicySnapshotRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final ListPagedResponse list(String project) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListSnapshotsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnapshotsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListSnapshotsRequest, SnapshotList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicySnapshotRequest request = SetIamPolicySnapshotRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicySnapshotRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicySnapshotRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Operation setLabels(String project, String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsSnapshotRequest request = SetLabelsSnapshotRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabels(request);
    }

    public final Operation setLabels(SetLabelsSnapshotRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsSnapshotRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsSnapshotRequest request = TestIamPermissionsSnapshotRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsSnapshotRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsSnapshotRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotsRequest, SnapshotList, Snapshot, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListSnapshotsRequest, SnapshotList, Snapshot, ListPage> {
        private ListPage(PageContext<ListSnapshotsRequest, SnapshotList, Snapshot> context, SnapshotList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListSnapshotsRequest, SnapshotList, Snapshot> context, SnapshotList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListSnapshotsRequest, SnapshotList, Snapshot> context, ApiFuture<SnapshotList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListSnapshotsRequest, SnapshotList, Snapshot, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListSnapshotsRequest, SnapshotList, Snapshot> context, ApiFuture<SnapshotList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

