/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.DeleteRegionAutoscalerRequest;
import com.google.cloud.compute.v1.GetRegionAutoscalerRequest;
import com.google.cloud.compute.v1.InsertRegionAutoscalerRequest;
import com.google.cloud.compute.v1.ListRegionAutoscalersRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionAutoscalerRequest;
import com.google.cloud.compute.v1.RegionAutoscalerList;
import com.google.cloud.compute.v1.RegionAutoscalersSettings;
import com.google.cloud.compute.v1.UpdateRegionAutoscalerRequest;
import com.google.cloud.compute.v1.stub.RegionAutoscalersStub;
import com.google.cloud.compute.v1.stub.RegionAutoscalersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionAutoscalersClient
implements BackgroundResource {
    private final RegionAutoscalersSettings settings;
    private final RegionAutoscalersStub stub;

    public static final RegionAutoscalersClient create() throws IOException {
        return RegionAutoscalersClient.create(RegionAutoscalersSettings.newBuilder().build());
    }

    public static final RegionAutoscalersClient create(RegionAutoscalersSettings settings) throws IOException {
        return new RegionAutoscalersClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionAutoscalersClient create(RegionAutoscalersStub stub) {
        return new RegionAutoscalersClient(stub);
    }

    protected RegionAutoscalersClient(RegionAutoscalersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionAutoscalersStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionAutoscalersClient(RegionAutoscalersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionAutoscalersSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionAutoscalersStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String region, String autoscaler) {
        DeleteRegionAutoscalerRequest request = DeleteRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscaler(autoscaler).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionAutoscalerRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionAutoscalerRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Autoscaler get(String project, String region, String autoscaler) {
        GetRegionAutoscalerRequest request = GetRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscaler(autoscaler).build();
        return this.get(request);
    }

    public final Autoscaler get(GetRegionAutoscalerRequest request) {
        return (Autoscaler)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionAutoscalerRequest, Autoscaler> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, Autoscaler autoscalerResource) {
        InsertRegionAutoscalerRequest request = InsertRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionAutoscalerRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionAutoscalerRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionAutoscalersRequest request = ListRegionAutoscalersRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionAutoscalersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionAutoscalersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionAutoscalersRequest, RegionAutoscalerList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, Autoscaler autoscalerResource) {
        PatchRegionAutoscalerRequest request = PatchRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchRegionAutoscalerRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchRegionAutoscalerRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String region, Autoscaler autoscalerResource) {
        UpdateRegionAutoscalerRequest request = UpdateRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateRegionAutoscalerRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRegionAutoscalerRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler, ListPage> {
        private ListPage(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, RegionAutoscalerList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, RegionAutoscalerList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, ApiFuture<RegionAutoscalerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, ApiFuture<RegionAutoscalerList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

