/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetHttpProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.TargetHttpProxyClient;
import com.google.cloud.compute.v1.TargetHttpProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetHttpProxyStub;
import com.google.cloud.compute.v1.stub.TargetHttpProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetHttpProxyStubSettings
extends StubSettings<TargetHttpProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteTargetHttpProxyHttpRequest, Operation> deleteTargetHttpProxySettings;
    private final UnaryCallSettings<GetTargetHttpProxyHttpRequest, TargetHttpProxy> getTargetHttpProxySettings;
    private final UnaryCallSettings<InsertTargetHttpProxyHttpRequest, Operation> insertTargetHttpProxySettings;
    private final PagedCallSettings<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse> listTargetHttpProxiesSettings;
    private final UnaryCallSettings<SetUrlMapTargetHttpProxyHttpRequest, Operation> setUrlMapTargetHttpProxySettings;
    private static final PagedListDescriptor<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> LIST_TARGET_HTTP_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetHttpProxiesHttpRequest injectToken(ListTargetHttpProxiesHttpRequest payload, String token) {
            return ListTargetHttpProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetHttpProxiesHttpRequest injectPageSize(ListTargetHttpProxiesHttpRequest payload, int pageSize) {
            return ListTargetHttpProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetHttpProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpProxy> extractResources(TargetHttpProxyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse> LIST_TARGET_HTTP_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse>(){

        public ApiFuture<TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList> callable, ListTargetHttpProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetHttpProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_HTTP_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse.createAsync((PageContext<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetHttpProxyHttpRequest, Operation> deleteTargetHttpProxySettings() {
        return this.deleteTargetHttpProxySettings;
    }

    public UnaryCallSettings<GetTargetHttpProxyHttpRequest, TargetHttpProxy> getTargetHttpProxySettings() {
        return this.getTargetHttpProxySettings;
    }

    public UnaryCallSettings<InsertTargetHttpProxyHttpRequest, Operation> insertTargetHttpProxySettings() {
        return this.insertTargetHttpProxySettings;
    }

    public PagedCallSettings<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse> listTargetHttpProxiesSettings() {
        return this.listTargetHttpProxiesSettings;
    }

    public UnaryCallSettings<SetUrlMapTargetHttpProxyHttpRequest, Operation> setUrlMapTargetHttpProxySettings() {
        return this.setUrlMapTargetHttpProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetHttpProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetHttpProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetHttpProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetHttpProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteTargetHttpProxySettings = settingsBuilder.deleteTargetHttpProxySettings().build();
        this.getTargetHttpProxySettings = settingsBuilder.getTargetHttpProxySettings().build();
        this.insertTargetHttpProxySettings = settingsBuilder.insertTargetHttpProxySettings().build();
        this.listTargetHttpProxiesSettings = settingsBuilder.listTargetHttpProxiesSettings().build();
        this.setUrlMapTargetHttpProxySettings = settingsBuilder.setUrlMapTargetHttpProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetHttpProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetHttpProxyHttpRequest, Operation> deleteTargetHttpProxySettings;
        private final UnaryCallSettings.Builder<GetTargetHttpProxyHttpRequest, TargetHttpProxy> getTargetHttpProxySettings;
        private final UnaryCallSettings.Builder<InsertTargetHttpProxyHttpRequest, Operation> insertTargetHttpProxySettings;
        private final PagedCallSettings.Builder<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse> listTargetHttpProxiesSettings;
        private final UnaryCallSettings.Builder<SetUrlMapTargetHttpProxyHttpRequest, Operation> setUrlMapTargetHttpProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetHttpProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_HTTP_PROXIES_PAGE_STR_FACT);
            this.setUrlMapTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetHttpProxySettings, this.getTargetHttpProxySettings, this.insertTargetHttpProxySettings, this.listTargetHttpProxiesSettings, this.setUrlMapTargetHttpProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetHttpProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetHttpProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetHttpProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetHttpProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetHttpProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setUrlMapTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetHttpProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteTargetHttpProxySettings = settings.deleteTargetHttpProxySettings.toBuilder();
            this.getTargetHttpProxySettings = settings.getTargetHttpProxySettings.toBuilder();
            this.insertTargetHttpProxySettings = settings.insertTargetHttpProxySettings.toBuilder();
            this.listTargetHttpProxiesSettings = settings.listTargetHttpProxiesSettings.toBuilder();
            this.setUrlMapTargetHttpProxySettings = settings.setUrlMapTargetHttpProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetHttpProxySettings, this.getTargetHttpProxySettings, this.insertTargetHttpProxySettings, this.listTargetHttpProxiesSettings, this.setUrlMapTargetHttpProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetHttpProxyHttpRequest, Operation> deleteTargetHttpProxySettings() {
            return this.deleteTargetHttpProxySettings;
        }

        public UnaryCallSettings.Builder<GetTargetHttpProxyHttpRequest, TargetHttpProxy> getTargetHttpProxySettings() {
            return this.getTargetHttpProxySettings;
        }

        public UnaryCallSettings.Builder<InsertTargetHttpProxyHttpRequest, Operation> insertTargetHttpProxySettings() {
            return this.insertTargetHttpProxySettings;
        }

        public PagedCallSettings.Builder<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxyClient.ListTargetHttpProxiesPagedResponse> listTargetHttpProxiesSettings() {
            return this.listTargetHttpProxiesSettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapTargetHttpProxyHttpRequest, Operation> setUrlMapTargetHttpProxySettings() {
            return this.setUrlMapTargetHttpProxySettings;
        }

        public TargetHttpProxyStubSettings build() throws IOException {
            return new TargetHttpProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

