/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListDisksHttpRequest;
import com.google.cloud.compute.v1.CreateSnapshotDiskHttpRequest;
import com.google.cloud.compute.v1.DeleteDiskHttpRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskAggregatedList;
import com.google.cloud.compute.v1.DiskClient;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.DisksScopedList;
import com.google.cloud.compute.v1.GetDiskHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyDiskHttpRequest;
import com.google.cloud.compute.v1.InsertDiskHttpRequest;
import com.google.cloud.compute.v1.ListDisksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ResizeDiskHttpRequest;
import com.google.cloud.compute.v1.SetIamPolicyDiskHttpRequest;
import com.google.cloud.compute.v1.SetLabelsDiskHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsDiskHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.DiskStub;
import com.google.cloud.compute.v1.stub.HttpJsonDiskStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DiskStubSettings
extends StubSettings<DiskStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListDisksHttpRequest, DiskAggregatedList, DiskClient.AggregatedListDisksPagedResponse> aggregatedListDisksSettings;
    private final UnaryCallSettings<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskSettings;
    private final UnaryCallSettings<DeleteDiskHttpRequest, Operation> deleteDiskSettings;
    private final UnaryCallSettings<GetDiskHttpRequest, Disk> getDiskSettings;
    private final UnaryCallSettings<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskSettings;
    private final UnaryCallSettings<InsertDiskHttpRequest, Operation> insertDiskSettings;
    private final PagedCallSettings<ListDisksHttpRequest, DiskList, DiskClient.ListDisksPagedResponse> listDisksSettings;
    private final UnaryCallSettings<ResizeDiskHttpRequest, Operation> resizeDiskSettings;
    private final UnaryCallSettings<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskSettings;
    private final UnaryCallSettings<SetLabelsDiskHttpRequest, Operation> setLabelsDiskSettings;
    private final UnaryCallSettings<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskSettings;
    private static final PagedListDescriptor<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList> AGGREGATED_LIST_DISKS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListDisksHttpRequest injectToken(AggregatedListDisksHttpRequest payload, String token) {
            return AggregatedListDisksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListDisksHttpRequest injectPageSize(AggregatedListDisksHttpRequest payload, int pageSize) {
            return AggregatedListDisksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListDisksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DisksScopedList> extractResources(DiskAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListDisksHttpRequest, DiskList, Disk> LIST_DISKS_PAGE_STR_DESC = new PagedListDescriptor<ListDisksHttpRequest, DiskList, Disk>(){

        public String emptyToken() {
            return "";
        }

        public ListDisksHttpRequest injectToken(ListDisksHttpRequest payload, String token) {
            return ListDisksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListDisksHttpRequest injectPageSize(ListDisksHttpRequest payload, int pageSize) {
            return ListDisksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListDisksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Disk> extractResources(DiskList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListDisksHttpRequest, DiskAggregatedList, DiskClient.AggregatedListDisksPagedResponse> AGGREGATED_LIST_DISKS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListDisksHttpRequest, DiskAggregatedList, DiskClient.AggregatedListDisksPagedResponse>(){

        public ApiFuture<DiskClient.AggregatedListDisksPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListDisksHttpRequest, DiskAggregatedList> callable, AggregatedListDisksHttpRequest request, ApiCallContext context, ApiFuture<DiskAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_DISKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DiskClient.AggregatedListDisksPagedResponse.createAsync((PageContext<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDisksHttpRequest, DiskList, DiskClient.ListDisksPagedResponse> LIST_DISKS_PAGE_STR_FACT = new PagedListResponseFactory<ListDisksHttpRequest, DiskList, DiskClient.ListDisksPagedResponse>(){

        public ApiFuture<DiskClient.ListDisksPagedResponse> getFuturePagedResponse(UnaryCallable<ListDisksHttpRequest, DiskList> callable, ListDisksHttpRequest request, ApiCallContext context, ApiFuture<DiskList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DiskClient.ListDisksPagedResponse.createAsync((PageContext<ListDisksHttpRequest, DiskList, Disk>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListDisksHttpRequest, DiskAggregatedList, DiskClient.AggregatedListDisksPagedResponse> aggregatedListDisksSettings() {
        return this.aggregatedListDisksSettings;
    }

    public UnaryCallSettings<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskSettings() {
        return this.createSnapshotDiskSettings;
    }

    public UnaryCallSettings<DeleteDiskHttpRequest, Operation> deleteDiskSettings() {
        return this.deleteDiskSettings;
    }

    public UnaryCallSettings<GetDiskHttpRequest, Disk> getDiskSettings() {
        return this.getDiskSettings;
    }

    public UnaryCallSettings<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskSettings() {
        return this.getIamPolicyDiskSettings;
    }

    public UnaryCallSettings<InsertDiskHttpRequest, Operation> insertDiskSettings() {
        return this.insertDiskSettings;
    }

    public PagedCallSettings<ListDisksHttpRequest, DiskList, DiskClient.ListDisksPagedResponse> listDisksSettings() {
        return this.listDisksSettings;
    }

    public UnaryCallSettings<ResizeDiskHttpRequest, Operation> resizeDiskSettings() {
        return this.resizeDiskSettings;
    }

    public UnaryCallSettings<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskSettings() {
        return this.setIamPolicyDiskSettings;
    }

    public UnaryCallSettings<SetLabelsDiskHttpRequest, Operation> setLabelsDiskSettings() {
        return this.setLabelsDiskSettings;
    }

    public UnaryCallSettings<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskSettings() {
        return this.testIamPermissionsDiskSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DiskStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDiskStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DiskStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DiskStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DiskStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListDisksSettings = settingsBuilder.aggregatedListDisksSettings().build();
        this.createSnapshotDiskSettings = settingsBuilder.createSnapshotDiskSettings().build();
        this.deleteDiskSettings = settingsBuilder.deleteDiskSettings().build();
        this.getDiskSettings = settingsBuilder.getDiskSettings().build();
        this.getIamPolicyDiskSettings = settingsBuilder.getIamPolicyDiskSettings().build();
        this.insertDiskSettings = settingsBuilder.insertDiskSettings().build();
        this.listDisksSettings = settingsBuilder.listDisksSettings().build();
        this.resizeDiskSettings = settingsBuilder.resizeDiskSettings().build();
        this.setIamPolicyDiskSettings = settingsBuilder.setIamPolicyDiskSettings().build();
        this.setLabelsDiskSettings = settingsBuilder.setLabelsDiskSettings().build();
        this.testIamPermissionsDiskSettings = settingsBuilder.testIamPermissionsDiskSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DiskStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListDisksHttpRequest, DiskAggregatedList, DiskClient.AggregatedListDisksPagedResponse> aggregatedListDisksSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskSettings;
        private final UnaryCallSettings.Builder<DeleteDiskHttpRequest, Operation> deleteDiskSettings;
        private final UnaryCallSettings.Builder<GetDiskHttpRequest, Disk> getDiskSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskSettings;
        private final UnaryCallSettings.Builder<InsertDiskHttpRequest, Operation> insertDiskSettings;
        private final PagedCallSettings.Builder<ListDisksHttpRequest, DiskList, DiskClient.ListDisksPagedResponse> listDisksSettings;
        private final UnaryCallSettings.Builder<ResizeDiskHttpRequest, Operation> resizeDiskSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskSettings;
        private final UnaryCallSettings.Builder<SetLabelsDiskHttpRequest, Operation> setLabelsDiskSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListDisksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_DISKS_PAGE_STR_FACT);
            this.createSnapshotDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicyDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDisksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISKS_PAGE_STR_FACT);
            this.resizeDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicyDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListDisksSettings, this.createSnapshotDiskSettings, this.deleteDiskSettings, this.getDiskSettings, this.getIamPolicyDiskSettings, this.insertDiskSettings, this.listDisksSettings, this.resizeDiskSettings, this.setIamPolicyDiskSettings, this.setLabelsDiskSettings, this.testIamPermissionsDiskSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DiskStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DiskStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DiskStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DiskStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListDisksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSnapshotDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicyDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listDisksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resizeDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicyDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(DiskStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListDisksSettings = settings.aggregatedListDisksSettings.toBuilder();
            this.createSnapshotDiskSettings = settings.createSnapshotDiskSettings.toBuilder();
            this.deleteDiskSettings = settings.deleteDiskSettings.toBuilder();
            this.getDiskSettings = settings.getDiskSettings.toBuilder();
            this.getIamPolicyDiskSettings = settings.getIamPolicyDiskSettings.toBuilder();
            this.insertDiskSettings = settings.insertDiskSettings.toBuilder();
            this.listDisksSettings = settings.listDisksSettings.toBuilder();
            this.resizeDiskSettings = settings.resizeDiskSettings.toBuilder();
            this.setIamPolicyDiskSettings = settings.setIamPolicyDiskSettings.toBuilder();
            this.setLabelsDiskSettings = settings.setLabelsDiskSettings.toBuilder();
            this.testIamPermissionsDiskSettings = settings.testIamPermissionsDiskSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListDisksSettings, this.createSnapshotDiskSettings, this.deleteDiskSettings, this.getDiskSettings, this.getIamPolicyDiskSettings, this.insertDiskSettings, this.listDisksSettings, this.resizeDiskSettings, this.setIamPolicyDiskSettings, this.setLabelsDiskSettings, this.testIamPermissionsDiskSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListDisksHttpRequest, DiskAggregatedList, DiskClient.AggregatedListDisksPagedResponse> aggregatedListDisksSettings() {
            return this.aggregatedListDisksSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskSettings() {
            return this.createSnapshotDiskSettings;
        }

        public UnaryCallSettings.Builder<DeleteDiskHttpRequest, Operation> deleteDiskSettings() {
            return this.deleteDiskSettings;
        }

        public UnaryCallSettings.Builder<GetDiskHttpRequest, Disk> getDiskSettings() {
            return this.getDiskSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskSettings() {
            return this.getIamPolicyDiskSettings;
        }

        public UnaryCallSettings.Builder<InsertDiskHttpRequest, Operation> insertDiskSettings() {
            return this.insertDiskSettings;
        }

        public PagedCallSettings.Builder<ListDisksHttpRequest, DiskList, DiskClient.ListDisksPagedResponse> listDisksSettings() {
            return this.listDisksSettings;
        }

        public UnaryCallSettings.Builder<ResizeDiskHttpRequest, Operation> resizeDiskSettings() {
            return this.resizeDiskSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskSettings() {
            return this.setIamPolicyDiskSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsDiskHttpRequest, Operation> setLabelsDiskSettings() {
            return this.setLabelsDiskSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskSettings() {
            return this.testIamPermissionsDiskSettings;
        }

        public DiskStubSettings build() throws IOException {
            return new DiskStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

