/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectDiagnosticsLinkLACPStatus
implements ApiMessage {
    private final String googleSystemId;
    private final String neighborSystemId;
    private final String state;
    private static final InterconnectDiagnosticsLinkLACPStatus DEFAULT_INSTANCE = new InterconnectDiagnosticsLinkLACPStatus();

    private InterconnectDiagnosticsLinkLACPStatus() {
        this.googleSystemId = null;
        this.neighborSystemId = null;
        this.state = null;
    }

    private InterconnectDiagnosticsLinkLACPStatus(String googleSystemId, String neighborSystemId, String state) {
        this.googleSystemId = googleSystemId;
        this.neighborSystemId = neighborSystemId;
        this.state = state;
    }

    public Object getFieldValue(String fieldName) {
        if ("googleSystemId".equals(fieldName)) {
            return this.googleSystemId;
        }
        if ("neighborSystemId".equals(fieldName)) {
            return this.neighborSystemId;
        }
        if ("state".equals(fieldName)) {
            return this.state;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getGoogleSystemId() {
        return this.googleSystemId;
    }

    public String getNeighborSystemId() {
        return this.neighborSystemId;
    }

    public String getState() {
        return this.state;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectDiagnosticsLinkLACPStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectDiagnosticsLinkLACPStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectDiagnosticsLinkLACPStatus{googleSystemId=" + this.googleSystemId + ", neighborSystemId=" + this.neighborSystemId + ", state=" + this.state + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectDiagnosticsLinkLACPStatus) {
            InterconnectDiagnosticsLinkLACPStatus that = (InterconnectDiagnosticsLinkLACPStatus)o;
            return Objects.equals(this.googleSystemId, that.getGoogleSystemId()) && Objects.equals(this.neighborSystemId, that.getNeighborSystemId()) && Objects.equals(this.state, that.getState());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.googleSystemId, this.neighborSystemId, this.state);
    }

    public static class Builder {
        private String googleSystemId;
        private String neighborSystemId;
        private String state;

        Builder() {
        }

        public Builder mergeFrom(InterconnectDiagnosticsLinkLACPStatus other) {
            if (other == InterconnectDiagnosticsLinkLACPStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getGoogleSystemId() != null) {
                this.googleSystemId = other.googleSystemId;
            }
            if (other.getNeighborSystemId() != null) {
                this.neighborSystemId = other.neighborSystemId;
            }
            if (other.getState() != null) {
                this.state = other.state;
            }
            return this;
        }

        Builder(InterconnectDiagnosticsLinkLACPStatus source) {
            this.googleSystemId = source.googleSystemId;
            this.neighborSystemId = source.neighborSystemId;
            this.state = source.state;
        }

        public String getGoogleSystemId() {
            return this.googleSystemId;
        }

        public Builder setGoogleSystemId(String googleSystemId) {
            this.googleSystemId = googleSystemId;
            return this;
        }

        public String getNeighborSystemId() {
            return this.neighborSystemId;
        }

        public Builder setNeighborSystemId(String neighborSystemId) {
            this.neighborSystemId = neighborSystemId;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public InterconnectDiagnosticsLinkLACPStatus build() {
            return new InterconnectDiagnosticsLinkLACPStatus(this.googleSystemId, this.neighborSystemId, this.state);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setGoogleSystemId(this.googleSystemId);
            newBuilder.setNeighborSystemId(this.neighborSystemId);
            newBuilder.setState(this.state);
            return newBuilder;
        }
    }
}

