/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstancesRegionInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.ListRegionInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionInstanceGroupClient;
import com.google.cloud.compute.v1.RegionInstanceGroupList;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstances;
import com.google.cloud.compute.v1.SetNamedPortsRegionInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionInstanceGroupStub;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionInstanceGroupStubSettings
extends StubSettings<RegionInstanceGroupStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<GetRegionInstanceGroupHttpRequest, InstanceGroup> getRegionInstanceGroupSettings;
    private final PagedCallSettings<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse> listRegionInstanceGroupsSettings;
    private final PagedCallSettings<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse> listInstancesRegionInstanceGroupsSettings;
    private final UnaryCallSettings<SetNamedPortsRegionInstanceGroupHttpRequest, Operation> setNamedPortsRegionInstanceGroupSettings;
    private static final PagedListDescriptor<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup> LIST_REGION_INSTANCE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionInstanceGroupsHttpRequest injectToken(ListRegionInstanceGroupsHttpRequest payload, String token) {
            return ListRegionInstanceGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionInstanceGroupsHttpRequest injectPageSize(ListRegionInstanceGroupsHttpRequest payload, int pageSize) {
            return ListRegionInstanceGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionInstanceGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroup> extractResources(RegionInstanceGroupList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> LIST_INSTANCES_REGION_INSTANCE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRegionInstanceGroupsHttpRequest injectToken(ListInstancesRegionInstanceGroupsHttpRequest payload, String token) {
            return ListInstancesRegionInstanceGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInstancesRegionInstanceGroupsHttpRequest injectPageSize(ListInstancesRegionInstanceGroupsHttpRequest payload, int pageSize) {
            return ListInstancesRegionInstanceGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRegionInstanceGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupsListInstances payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceWithNamedPorts> extractResources(RegionInstanceGroupsListInstances payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse> LIST_REGION_INSTANCE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse>(){

        public ApiFuture<RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList> callable, ListRegionInstanceGroupsHttpRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_INSTANCE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse.createAsync((PageContext<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse> LIST_INSTANCES_REGION_INSTANCE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse>(){

        public ApiFuture<RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances> callable, ListInstancesRegionInstanceGroupsHttpRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupsListInstances> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_REGION_INSTANCE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse.createAsync((PageContext<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetRegionInstanceGroupHttpRequest, InstanceGroup> getRegionInstanceGroupSettings() {
        return this.getRegionInstanceGroupSettings;
    }

    public PagedCallSettings<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse> listRegionInstanceGroupsSettings() {
        return this.listRegionInstanceGroupsSettings;
    }

    public PagedCallSettings<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse> listInstancesRegionInstanceGroupsSettings() {
        return this.listInstancesRegionInstanceGroupsSettings;
    }

    public UnaryCallSettings<SetNamedPortsRegionInstanceGroupHttpRequest, Operation> setNamedPortsRegionInstanceGroupSettings() {
        return this.setNamedPortsRegionInstanceGroupSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionInstanceGroupStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionInstanceGroupStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionInstanceGroupStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionInstanceGroupStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionInstanceGroupStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getRegionInstanceGroupSettings = settingsBuilder.getRegionInstanceGroupSettings().build();
        this.listRegionInstanceGroupsSettings = settingsBuilder.listRegionInstanceGroupsSettings().build();
        this.listInstancesRegionInstanceGroupsSettings = settingsBuilder.listInstancesRegionInstanceGroupsSettings().build();
        this.setNamedPortsRegionInstanceGroupSettings = settingsBuilder.setNamedPortsRegionInstanceGroupSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionInstanceGroupStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetRegionInstanceGroupHttpRequest, InstanceGroup> getRegionInstanceGroupSettings;
        private final PagedCallSettings.Builder<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse> listRegionInstanceGroupsSettings;
        private final PagedCallSettings.Builder<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse> listInstancesRegionInstanceGroupsSettings;
        private final UnaryCallSettings.Builder<SetNamedPortsRegionInstanceGroupHttpRequest, Operation> setNamedPortsRegionInstanceGroupSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getRegionInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionInstanceGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_INSTANCE_GROUPS_PAGE_STR_FACT);
            this.listInstancesRegionInstanceGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_REGION_INSTANCE_GROUPS_PAGE_STR_FACT);
            this.setNamedPortsRegionInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRegionInstanceGroupSettings, this.listRegionInstanceGroupsSettings, this.listInstancesRegionInstanceGroupsSettings, this.setNamedPortsRegionInstanceGroupSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionInstanceGroupStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionInstanceGroupStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionInstanceGroupStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionInstanceGroupStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getRegionInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionInstanceGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstancesRegionInstanceGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setNamedPortsRegionInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionInstanceGroupStubSettings settings) {
            super((StubSettings)settings);
            this.getRegionInstanceGroupSettings = settings.getRegionInstanceGroupSettings.toBuilder();
            this.listRegionInstanceGroupsSettings = settings.listRegionInstanceGroupsSettings.toBuilder();
            this.listInstancesRegionInstanceGroupsSettings = settings.listInstancesRegionInstanceGroupsSettings.toBuilder();
            this.setNamedPortsRegionInstanceGroupSettings = settings.setNamedPortsRegionInstanceGroupSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRegionInstanceGroupSettings, this.listRegionInstanceGroupsSettings, this.listInstancesRegionInstanceGroupsSettings, this.setNamedPortsRegionInstanceGroupSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetRegionInstanceGroupHttpRequest, InstanceGroup> getRegionInstanceGroupSettings() {
            return this.getRegionInstanceGroupSettings;
        }

        public PagedCallSettings.Builder<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, RegionInstanceGroupClient.ListRegionInstanceGroupsPagedResponse> listRegionInstanceGroupsSettings() {
            return this.listRegionInstanceGroupsSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupClient.ListInstancesRegionInstanceGroupsPagedResponse> listInstancesRegionInstanceGroupsSettings() {
            return this.listInstancesRegionInstanceGroupsSettings;
        }

        public UnaryCallSettings.Builder<SetNamedPortsRegionInstanceGroupHttpRequest, Operation> setNamedPortsRegionInstanceGroupSettings() {
            return this.setNamedPortsRegionInstanceGroupSettings;
        }

        public RegionInstanceGroupStubSettings build() throws IOException {
            return new RegionInstanceGroupStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

