/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.DeleteNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.GetNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.InsertNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupAggregatedList;
import com.google.cloud.compute.v1.NetworkEndpointGroupClient;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointGroupsScopedList;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNetworkEndpointGroupStub;
import com.google.cloud.compute.v1.stub.NetworkEndpointGroupStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NetworkEndpointGroupStubSettings
extends StubSettings<NetworkEndpointGroupStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse> aggregatedListNetworkEndpointGroupsSettings;
    private final UnaryCallSettings<AttachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsNetworkEndpointGroupSettings;
    private final UnaryCallSettings<DeleteNetworkEndpointGroupHttpRequest, Operation> deleteNetworkEndpointGroupSettings;
    private final UnaryCallSettings<DetachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsNetworkEndpointGroupSettings;
    private final UnaryCallSettings<GetNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getNetworkEndpointGroupSettings;
    private final UnaryCallSettings<InsertNetworkEndpointGroupHttpRequest, Operation> insertNetworkEndpointGroupSettings;
    private final PagedCallSettings<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse> listNetworkEndpointGroupsSettings;
    private final PagedCallSettings<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> listNetworkEndpointsNetworkEndpointGroupsSettings;
    private final UnaryCallSettings<TestIamPermissionsNetworkEndpointGroupHttpRequest, TestPermissionsResponse> testIamPermissionsNetworkEndpointGroupSettings;
    private static final PagedListDescriptor<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList> AGGREGATED_LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNetworkEndpointGroupsHttpRequest injectToken(AggregatedListNetworkEndpointGroupsHttpRequest payload, String token) {
            return AggregatedListNetworkEndpointGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListNetworkEndpointGroupsHttpRequest injectPageSize(AggregatedListNetworkEndpointGroupsHttpRequest payload, int pageSize) {
            return AggregatedListNetworkEndpointGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNetworkEndpointGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointGroupsScopedList> extractResources(NetworkEndpointGroupAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkEndpointGroupsHttpRequest injectToken(ListNetworkEndpointGroupsHttpRequest payload, String token) {
            return ListNetworkEndpointGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNetworkEndpointGroupsHttpRequest injectPageSize(ListNetworkEndpointGroupsHttpRequest payload, int pageSize) {
            return ListNetworkEndpointGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkEndpointGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointGroup> extractResources(NetworkEndpointGroupList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> LIST_NETWORK_ENDPOINTS_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkEndpointsNetworkEndpointGroupsHttpRequest injectToken(ListNetworkEndpointsNetworkEndpointGroupsHttpRequest payload, String token) {
            return ListNetworkEndpointsNetworkEndpointGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNetworkEndpointsNetworkEndpointGroupsHttpRequest injectPageSize(ListNetworkEndpointsNetworkEndpointGroupsHttpRequest payload, int pageSize) {
            return ListNetworkEndpointsNetworkEndpointGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkEndpointsNetworkEndpointGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointWithHealthStatus> extractResources(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse> AGGREGATED_LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse>(){

        public ApiFuture<NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList> callable, AggregatedListNetworkEndpointGroupsHttpRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse.createAsync((PageContext<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse> LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse>(){

        public ApiFuture<NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList> callable, ListNetworkEndpointGroupsHttpRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse.createAsync((PageContext<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> LIST_NETWORK_ENDPOINTS_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse>(){

        public ApiFuture<NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints> callable, ListNetworkEndpointsNetworkEndpointGroupsHttpRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORK_ENDPOINTS_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse.createAsync((PageContext<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse> aggregatedListNetworkEndpointGroupsSettings() {
        return this.aggregatedListNetworkEndpointGroupsSettings;
    }

    public UnaryCallSettings<AttachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsNetworkEndpointGroupSettings() {
        return this.attachNetworkEndpointsNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<DeleteNetworkEndpointGroupHttpRequest, Operation> deleteNetworkEndpointGroupSettings() {
        return this.deleteNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<DetachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsNetworkEndpointGroupSettings() {
        return this.detachNetworkEndpointsNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<GetNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getNetworkEndpointGroupSettings() {
        return this.getNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<InsertNetworkEndpointGroupHttpRequest, Operation> insertNetworkEndpointGroupSettings() {
        return this.insertNetworkEndpointGroupSettings;
    }

    public PagedCallSettings<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse> listNetworkEndpointGroupsSettings() {
        return this.listNetworkEndpointGroupsSettings;
    }

    public PagedCallSettings<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> listNetworkEndpointsNetworkEndpointGroupsSettings() {
        return this.listNetworkEndpointsNetworkEndpointGroupsSettings;
    }

    public UnaryCallSettings<TestIamPermissionsNetworkEndpointGroupHttpRequest, TestPermissionsResponse> testIamPermissionsNetworkEndpointGroupSettings() {
        return this.testIamPermissionsNetworkEndpointGroupSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkEndpointGroupStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworkEndpointGroupStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworkEndpointGroupStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworkEndpointGroupStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworkEndpointGroupStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListNetworkEndpointGroupsSettings = settingsBuilder.aggregatedListNetworkEndpointGroupsSettings().build();
        this.attachNetworkEndpointsNetworkEndpointGroupSettings = settingsBuilder.attachNetworkEndpointsNetworkEndpointGroupSettings().build();
        this.deleteNetworkEndpointGroupSettings = settingsBuilder.deleteNetworkEndpointGroupSettings().build();
        this.detachNetworkEndpointsNetworkEndpointGroupSettings = settingsBuilder.detachNetworkEndpointsNetworkEndpointGroupSettings().build();
        this.getNetworkEndpointGroupSettings = settingsBuilder.getNetworkEndpointGroupSettings().build();
        this.insertNetworkEndpointGroupSettings = settingsBuilder.insertNetworkEndpointGroupSettings().build();
        this.listNetworkEndpointGroupsSettings = settingsBuilder.listNetworkEndpointGroupsSettings().build();
        this.listNetworkEndpointsNetworkEndpointGroupsSettings = settingsBuilder.listNetworkEndpointsNetworkEndpointGroupsSettings().build();
        this.testIamPermissionsNetworkEndpointGroupSettings = settingsBuilder.testIamPermissionsNetworkEndpointGroupSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworkEndpointGroupStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse> aggregatedListNetworkEndpointGroupsSettings;
        private final UnaryCallSettings.Builder<AttachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkEndpointGroupHttpRequest, Operation> deleteNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<DetachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<GetNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<InsertNetworkEndpointGroupHttpRequest, Operation> insertNetworkEndpointGroupSettings;
        private final PagedCallSettings.Builder<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse> listNetworkEndpointGroupsSettings;
        private final PagedCallSettings.Builder<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> listNetworkEndpointsNetworkEndpointGroupsSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsNetworkEndpointGroupHttpRequest, TestPermissionsResponse> testIamPermissionsNetworkEndpointGroupSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListNetworkEndpointGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT);
            this.attachNetworkEndpointsNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachNetworkEndpointsNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNetworkEndpointGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT);
            this.listNetworkEndpointsNetworkEndpointGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORK_ENDPOINTS_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT);
            this.testIamPermissionsNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListNetworkEndpointGroupsSettings, this.attachNetworkEndpointsNetworkEndpointGroupSettings, this.deleteNetworkEndpointGroupSettings, this.detachNetworkEndpointsNetworkEndpointGroupSettings, this.getNetworkEndpointGroupSettings, this.insertNetworkEndpointGroupSettings, this.listNetworkEndpointGroupsSettings, this.listNetworkEndpointsNetworkEndpointGroupsSettings, this.testIamPermissionsNetworkEndpointGroupSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworkEndpointGroupStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworkEndpointGroupStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworkEndpointGroupStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NetworkEndpointGroupStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListNetworkEndpointGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.attachNetworkEndpointsNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.detachNetworkEndpointsNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNetworkEndpointGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNetworkEndpointsNetworkEndpointGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(NetworkEndpointGroupStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListNetworkEndpointGroupsSettings = settings.aggregatedListNetworkEndpointGroupsSettings.toBuilder();
            this.attachNetworkEndpointsNetworkEndpointGroupSettings = settings.attachNetworkEndpointsNetworkEndpointGroupSettings.toBuilder();
            this.deleteNetworkEndpointGroupSettings = settings.deleteNetworkEndpointGroupSettings.toBuilder();
            this.detachNetworkEndpointsNetworkEndpointGroupSettings = settings.detachNetworkEndpointsNetworkEndpointGroupSettings.toBuilder();
            this.getNetworkEndpointGroupSettings = settings.getNetworkEndpointGroupSettings.toBuilder();
            this.insertNetworkEndpointGroupSettings = settings.insertNetworkEndpointGroupSettings.toBuilder();
            this.listNetworkEndpointGroupsSettings = settings.listNetworkEndpointGroupsSettings.toBuilder();
            this.listNetworkEndpointsNetworkEndpointGroupsSettings = settings.listNetworkEndpointsNetworkEndpointGroupsSettings.toBuilder();
            this.testIamPermissionsNetworkEndpointGroupSettings = settings.testIamPermissionsNetworkEndpointGroupSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListNetworkEndpointGroupsSettings, this.attachNetworkEndpointsNetworkEndpointGroupSettings, this.deleteNetworkEndpointGroupSettings, this.detachNetworkEndpointsNetworkEndpointGroupSettings, this.getNetworkEndpointGroupSettings, this.insertNetworkEndpointGroupSettings, this.listNetworkEndpointGroupsSettings, this.listNetworkEndpointsNetworkEndpointGroupsSettings, this.testIamPermissionsNetworkEndpointGroupSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupClient.AggregatedListNetworkEndpointGroupsPagedResponse> aggregatedListNetworkEndpointGroupsSettings() {
            return this.aggregatedListNetworkEndpointGroupsSettings;
        }

        public UnaryCallSettings.Builder<AttachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsNetworkEndpointGroupSettings() {
            return this.attachNetworkEndpointsNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkEndpointGroupHttpRequest, Operation> deleteNetworkEndpointGroupSettings() {
            return this.deleteNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<DetachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsNetworkEndpointGroupSettings() {
            return this.detachNetworkEndpointsNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getNetworkEndpointGroupSettings() {
            return this.getNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<InsertNetworkEndpointGroupHttpRequest, Operation> insertNetworkEndpointGroupSettings() {
            return this.insertNetworkEndpointGroupSettings;
        }

        public PagedCallSettings.Builder<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroupClient.ListNetworkEndpointGroupsPagedResponse> listNetworkEndpointGroupsSettings() {
            return this.listNetworkEndpointGroupsSettings;
        }

        public PagedCallSettings.Builder<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupClient.ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> listNetworkEndpointsNetworkEndpointGroupsSettings() {
            return this.listNetworkEndpointsNetworkEndpointGroupsSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsNetworkEndpointGroupHttpRequest, TestPermissionsResponse> testIamPermissionsNetworkEndpointGroupSettings() {
            return this.testIamPermissionsNetworkEndpointGroupSettings;
        }

        public NetworkEndpointGroupStubSettings build() throws IOException {
            return new NetworkEndpointGroupStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

