/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.FixedOrPercent;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagerUpdatePolicy
implements ApiMessage {
    private final FixedOrPercent maxSurge;
    private final FixedOrPercent maxUnavailable;
    private final String minimalAction;
    private final String type;
    private static final InstanceGroupManagerUpdatePolicy DEFAULT_INSTANCE = new InstanceGroupManagerUpdatePolicy();

    private InstanceGroupManagerUpdatePolicy() {
        this.maxSurge = null;
        this.maxUnavailable = null;
        this.minimalAction = null;
        this.type = null;
    }

    private InstanceGroupManagerUpdatePolicy(FixedOrPercent maxSurge, FixedOrPercent maxUnavailable, String minimalAction, String type) {
        this.maxSurge = maxSurge;
        this.maxUnavailable = maxUnavailable;
        this.minimalAction = minimalAction;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if ("maxSurge".equals(fieldName)) {
            return this.maxSurge;
        }
        if ("maxUnavailable".equals(fieldName)) {
            return this.maxUnavailable;
        }
        if ("minimalAction".equals(fieldName)) {
            return this.minimalAction;
        }
        if ("type".equals(fieldName)) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public FixedOrPercent getMaxSurge() {
        return this.maxSurge;
    }

    public FixedOrPercent getMaxUnavailable() {
        return this.maxUnavailable;
    }

    public String getMinimalAction() {
        return this.minimalAction;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagerUpdatePolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagerUpdatePolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagerUpdatePolicy{maxSurge=" + this.maxSurge + ", maxUnavailable=" + this.maxUnavailable + ", minimalAction=" + this.minimalAction + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagerUpdatePolicy) {
            InstanceGroupManagerUpdatePolicy that = (InstanceGroupManagerUpdatePolicy)o;
            return Objects.equals(this.maxSurge, that.getMaxSurge()) && Objects.equals(this.maxUnavailable, that.getMaxUnavailable()) && Objects.equals(this.minimalAction, that.getMinimalAction()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxSurge, this.maxUnavailable, this.minimalAction, this.type);
    }

    public static class Builder {
        private FixedOrPercent maxSurge;
        private FixedOrPercent maxUnavailable;
        private String minimalAction;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagerUpdatePolicy other) {
            if (other == InstanceGroupManagerUpdatePolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getMaxSurge() != null) {
                this.maxSurge = other.maxSurge;
            }
            if (other.getMaxUnavailable() != null) {
                this.maxUnavailable = other.maxUnavailable;
            }
            if (other.getMinimalAction() != null) {
                this.minimalAction = other.minimalAction;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(InstanceGroupManagerUpdatePolicy source) {
            this.maxSurge = source.maxSurge;
            this.maxUnavailable = source.maxUnavailable;
            this.minimalAction = source.minimalAction;
            this.type = source.type;
        }

        public FixedOrPercent getMaxSurge() {
            return this.maxSurge;
        }

        public Builder setMaxSurge(FixedOrPercent maxSurge) {
            this.maxSurge = maxSurge;
            return this;
        }

        public FixedOrPercent getMaxUnavailable() {
            return this.maxUnavailable;
        }

        public Builder setMaxUnavailable(FixedOrPercent maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
            return this;
        }

        public String getMinimalAction() {
            return this.minimalAction;
        }

        public Builder setMinimalAction(String minimalAction) {
            this.minimalAction = minimalAction;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public InstanceGroupManagerUpdatePolicy build() {
            return new InstanceGroupManagerUpdatePolicy(this.maxSurge, this.maxUnavailable, this.minimalAction, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setMaxSurge(this.maxSurge);
            newBuilder.setMaxUnavailable(this.maxUnavailable);
            newBuilder.setMinimalAction(this.minimalAction);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

