/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.services.compute.model.Address;
import com.google.cloud.compute.deprecated.AddressId;
import com.google.cloud.compute.deprecated.GlobalAddressId;
import com.google.cloud.compute.deprecated.GlobalForwardingRuleId;
import com.google.cloud.compute.deprecated.InstanceId;
import com.google.cloud.compute.deprecated.RegionAddressId;
import com.google.cloud.compute.deprecated.RegionForwardingRuleId;
import com.google.cloud.compute.deprecated.RegionId;
import com.google.cloud.compute.deprecated.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public class AddressInfo
implements Serializable {
    static final Function<Address, AddressInfo> FROM_PB_FUNCTION = new Function<Address, AddressInfo>(){

        public AddressInfo apply(Address pb) {
            return AddressInfo.fromPb(pb);
        }
    };
    static final Function<AddressInfo, Address> TO_PB_FUNCTION = new Function<AddressInfo, Address>(){

        public Address apply(AddressInfo addressInfo) {
            return addressInfo.toPb();
        }
    };
    private static final long serialVersionUID = 7678434703520207500L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone((ZoneId)ZoneOffset.UTC);
    private final String address;
    private final Long creationTimestamp;
    private final String description;
    private final String generatedId;
    private final AddressId addressId;
    private final Status status;
    private final Usage usage;

    AddressInfo(BuilderImpl builder) {
        this.address = builder.address;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.generatedId = builder.generatedId;
        this.addressId = (AddressId)Preconditions.checkNotNull((Object)builder.addressId);
        this.status = builder.status;
        this.usage = builder.usage;
    }

    public String getAddress() {
        return this.address;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public <T extends AddressId> T getAddressId() {
        return (T)this.addressId;
    }

    public Status getStatus() {
        return this.status;
    }

    public <T extends Usage> T getUsage() {
        return (T)this.usage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("creationTimestamp", (Object)this.creationTimestamp).add("description", (Object)this.description).add("generatedId", (Object)this.generatedId).add("addressId", (Object)this.addressId).add("status", (Object)this.status).add("usage", (Object)this.usage).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.creationTimestamp, this.description, this.generatedId, this.addressId, this.status, this.usage});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(AddressInfo.class) && Objects.equals(this.toPb(), ((AddressInfo)obj).toPb());
    }

    AddressInfo setProjectId(String projectId) {
        if (((ResourceId)this.getAddressId()).getProject() != null) {
            return this;
        }
        return this.toBuilder().setAddressId(this.addressId.setProjectId(projectId)).build();
    }

    Address toPb() {
        Address addressPb = this.usage != null ? this.usage.toPb() : new Address();
        addressPb.setAddress(this.address);
        if (this.creationTimestamp != null) {
            addressPb.setCreationTimestamp(TIMESTAMP_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((long)this.creationTimestamp)));
        }
        addressPb.setDescription(this.description);
        if (this.generatedId != null) {
            addressPb.setId(new BigInteger(this.generatedId));
        }
        addressPb.setName(this.addressId.getAddress());
        if (this.addressId.getType() == AddressId.Type.REGION) {
            addressPb.setRegion(((RegionAddressId)this.getAddressId()).getRegionId().getSelfLink());
        }
        if (this.status != null) {
            addressPb.setStatus(this.status.name());
        }
        addressPb.setSelfLink(this.addressId.getSelfLink());
        return addressPb;
    }

    public static Builder newBuilder(AddressId addressId) {
        return new BuilderImpl().setAddressId(addressId);
    }

    public static AddressInfo of(AddressId addressId) {
        return AddressInfo.newBuilder(addressId).build();
    }

    public static AddressInfo of(String name) {
        return AddressInfo.of(GlobalAddressId.of(name));
    }

    public static AddressInfo of(RegionId regionId, String name) {
        return AddressInfo.of(RegionAddressId.of(regionId, name));
    }

    public static AddressInfo of(String region, String name) {
        return AddressInfo.of(RegionAddressId.of(region, name));
    }

    static AddressInfo fromPb(Address addressPb) {
        return new BuilderImpl(addressPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String address;
        private Long creationTimestamp;
        private String description;
        private String generatedId;
        private AddressId addressId;
        private Status status;
        private Usage usage;

        BuilderImpl() {
        }

        BuilderImpl(AddressInfo addressInfo) {
            this.address = addressInfo.address;
            this.creationTimestamp = addressInfo.creationTimestamp;
            this.description = addressInfo.description;
            this.generatedId = addressInfo.generatedId;
            this.addressId = addressInfo.addressId;
            this.status = addressInfo.status;
            this.usage = addressInfo.usage;
        }

        BuilderImpl(Address addressPb) {
            this.addressId = RegionAddressId.matchesUrl(addressPb.getSelfLink()) ? RegionAddressId.fromUrl(addressPb.getSelfLink()) : GlobalAddressId.fromUrl(addressPb.getSelfLink());
            this.address = addressPb.getAddress();
            if (addressPb.getCreationTimestamp() != null) {
                this.creationTimestamp = ((Instant)TIMESTAMP_FORMATTER.parse((CharSequence)addressPb.getCreationTimestamp(), Instant.FROM)).toEpochMilli();
            }
            this.description = addressPb.getDescription();
            if (addressPb.getId() != null) {
                this.generatedId = addressPb.getId().toString();
            }
            if (addressPb.getStatus() != null) {
                this.status = Status.valueOf(addressPb.getStatus());
            }
            if (addressPb.getUsers() != null && addressPb.getUsers().size() > 0) {
                this.usage = Usage.fromPb(addressPb);
            }
        }

        @Override
        public BuilderImpl setAddress(String address) {
            this.address = address;
            return this;
        }

        @Override
        BuilderImpl setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public BuilderImpl setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        BuilderImpl setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public BuilderImpl setAddressId(AddressId addressId) {
            this.addressId = (AddressId)Preconditions.checkNotNull((Object)addressId);
            return this;
        }

        @Override
        BuilderImpl setStatus(Status status) {
            this.status = status;
            return this;
        }

        @Override
        BuilderImpl setUsage(Usage usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public AddressInfo build() {
            return new AddressInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setAddress(String var1);

        abstract Builder setCreationTimestamp(Long var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setGeneratedId(String var1);

        public abstract Builder setAddressId(AddressId var1);

        abstract Builder setStatus(Status var1);

        abstract Builder setUsage(Usage var1);

        public abstract AddressInfo build();
    }

    public static final class GlobalForwardingUsage
    extends Usage {
        private static final long serialVersionUID = -2974154224319117433L;
        private final List<GlobalForwardingRuleId> forwardingRules;

        GlobalForwardingUsage(List<GlobalForwardingRuleId> forwardingRules) {
            this.forwardingRules = ImmutableList.copyOf(forwardingRules);
        }

        public List<GlobalForwardingRuleId> getForwardingRules() {
            return this.forwardingRules;
        }

        public List<GlobalForwardingRuleId> getUsers() {
            return this.forwardingRules;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("forwardingRules", this.forwardingRules).toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof GlobalForwardingUsage && this.baseEquals((GlobalForwardingUsage)obj);
        }

        public int hashCode() {
            return Objects.hash(this.forwardingRules);
        }

        static GlobalForwardingUsage fromPb(Address addressPb) {
            return new GlobalForwardingUsage(Lists.transform((List)addressPb.getUsers(), GlobalForwardingRuleId.FROM_URL_FUNCTION));
        }
    }

    public static final class RegionForwardingUsage
    extends Usage {
        private static final long serialVersionUID = -4255145869626427363L;
        private final List<RegionForwardingRuleId> forwardingRules;

        RegionForwardingUsage(List<RegionForwardingRuleId> forwardingRules) {
            this.forwardingRules = ImmutableList.copyOf(forwardingRules);
        }

        public List<RegionForwardingRuleId> getForwardingRules() {
            return this.forwardingRules;
        }

        public List<RegionForwardingRuleId> getUsers() {
            return this.forwardingRules;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("forwardingRules", this.forwardingRules).toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof RegionForwardingUsage && this.baseEquals((RegionForwardingUsage)obj);
        }

        public int hashCode() {
            return Objects.hash(this.forwardingRules);
        }

        static RegionForwardingUsage fromPb(Address addressPb) {
            return new RegionForwardingUsage(Lists.transform((List)addressPb.getUsers(), RegionForwardingRuleId.FROM_URL_FUNCTION));
        }
    }

    public static final class InstanceUsage
    extends Usage {
        private static final long serialVersionUID = -5028609518171408695L;
        private final InstanceId instance;

        InstanceUsage(InstanceId instance) {
            this.instance = (InstanceId)Preconditions.checkNotNull((Object)instance);
        }

        public InstanceId getInstance() {
            return this.instance;
        }

        public List<InstanceId> getUsers() {
            return ImmutableList.of((Object)this.instance);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("instance", (Object)this.instance).toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof InstanceUsage && this.baseEquals((InstanceUsage)obj);
        }

        public int hashCode() {
            return Objects.hash(this.instance);
        }

        static InstanceUsage fromPb(Address addressPb) {
            return new InstanceUsage(InstanceId.fromUrl((String)addressPb.getUsers().get(0)));
        }
    }

    public static abstract class Usage
    implements Serializable {
        private static final long serialVersionUID = -5028609518171408695L;

        Usage() {
        }

        public abstract List<? extends ResourceId> getUsers();

        final boolean baseEquals(Usage usage) {
            return Objects.equals(this.toPb(), usage.toPb());
        }

        Address toPb() {
            return new Address().setUsers(Lists.transform(this.getUsers(), (Function)new Function<ResourceId, String>(){

                public String apply(ResourceId resourceId) {
                    return resourceId.getSelfLink();
                }
            }));
        }

        static <T extends Usage> T fromPb(Address addressPb) {
            String url = (String)addressPb.getUsers().get(0);
            if (InstanceId.matchesUrl(url)) {
                return (T)InstanceUsage.fromPb(addressPb);
            }
            if (RegionForwardingRuleId.matchesUrl(url)) {
                return (T)RegionForwardingUsage.fromPb(addressPb);
            }
            if (GlobalForwardingRuleId.matchesUrl(url)) {
                return (T)GlobalForwardingUsage.fromPb(addressPb);
            }
            throw new IllegalArgumentException("Unexpected resource URL for address user");
        }
    }

    public static enum Status {
        RESERVED,
        IN_USE;

    }
}

