/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.FixedOrPercent;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagerVersion
implements ApiMessage {
    private final String instanceTemplate;
    private final String name;
    private final FixedOrPercent targetSize;
    private static final InstanceGroupManagerVersion DEFAULT_INSTANCE = new InstanceGroupManagerVersion();

    private InstanceGroupManagerVersion() {
        this.instanceTemplate = null;
        this.name = null;
        this.targetSize = null;
    }

    private InstanceGroupManagerVersion(String instanceTemplate, String name, FixedOrPercent targetSize) {
        this.instanceTemplate = instanceTemplate;
        this.name = name;
        this.targetSize = targetSize;
    }

    public Object getFieldValue(String fieldName) {
        if ("instanceTemplate".equals(fieldName)) {
            return this.instanceTemplate;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("targetSize".equals(fieldName)) {
            return this.targetSize;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInstanceTemplate() {
        return this.instanceTemplate;
    }

    public String getName() {
        return this.name;
    }

    public FixedOrPercent getTargetSize() {
        return this.targetSize;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagerVersion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagerVersion getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagerVersion{instanceTemplate=" + this.instanceTemplate + ", name=" + this.name + ", targetSize=" + this.targetSize + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagerVersion) {
            InstanceGroupManagerVersion that = (InstanceGroupManagerVersion)o;
            return Objects.equals(this.instanceTemplate, that.getInstanceTemplate()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.targetSize, that.getTargetSize());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceTemplate, this.name, this.targetSize);
    }

    public static class Builder {
        private String instanceTemplate;
        private String name;
        private FixedOrPercent targetSize;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagerVersion other) {
            if (other == InstanceGroupManagerVersion.getDefaultInstance()) {
                return this;
            }
            if (other.getInstanceTemplate() != null) {
                this.instanceTemplate = other.instanceTemplate;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getTargetSize() != null) {
                this.targetSize = other.targetSize;
            }
            return this;
        }

        Builder(InstanceGroupManagerVersion source) {
            this.instanceTemplate = source.instanceTemplate;
            this.name = source.name;
            this.targetSize = source.targetSize;
        }

        public String getInstanceTemplate() {
            return this.instanceTemplate;
        }

        public Builder setInstanceTemplate(String instanceTemplate) {
            this.instanceTemplate = instanceTemplate;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public FixedOrPercent getTargetSize() {
            return this.targetSize;
        }

        public Builder setTargetSize(FixedOrPercent targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public InstanceGroupManagerVersion build() {
            return new InstanceGroupManagerVersion(this.instanceTemplate, this.name, this.targetSize);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInstanceTemplate(this.instanceTemplate);
            newBuilder.setName(this.name);
            newBuilder.setTargetSize(this.targetSize);
            return newBuilder;
        }
    }
}

