/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AddPeeringNetworkHttpRequest;
import com.google.cloud.compute.v1.DeleteNetworkHttpRequest;
import com.google.cloud.compute.v1.GetNetworkHttpRequest;
import com.google.cloud.compute.v1.InsertNetworkHttpRequest;
import com.google.cloud.compute.v1.ListNetworksHttpRequest;
import com.google.cloud.compute.v1.Network;
import com.google.cloud.compute.v1.NetworkClient;
import com.google.cloud.compute.v1.NetworkList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalNetworkName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.RemovePeeringNetworkHttpRequest;
import com.google.cloud.compute.v1.SwitchToCustomModeNetworkHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonNetworkCallableFactory;
import com.google.cloud.compute.v1.stub.NetworkStub;
import com.google.cloud.compute.v1.stub.NetworkStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonNetworkStub
extends NetworkStub {
    @InternalApi
    public static final ApiMethodDescriptor<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.addPeering").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks/{network}/addPeering")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalNetworkName.newFactory()).setResourceNameField("network").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteNetworkHttpRequest, Operation> deleteNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks/{network}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalNetworkName.newFactory()).setResourceNameField("network").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetNetworkHttpRequest, Network> getNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks/{network}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalNetworkName.newFactory()).setResourceNameField("network").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Network.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertNetworkHttpRequest, Operation> insertNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListNetworksHttpRequest, NetworkList> listNetworksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)NetworkList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchNetworkHttpRequest, Operation> patchNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks/{network}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalNetworkName.newFactory()).setResourceNameField("network").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.removePeering").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks/{network}/removePeering")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalNetworkName.newFactory()).setResourceNameField("network").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.networks.switchToCustomMode").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/networks/{network}/switchToCustomMode")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalNetworkName.newFactory()).setResourceNameField("network").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkCallable;
    private final UnaryCallable<DeleteNetworkHttpRequest, Operation> deleteNetworkCallable;
    private final UnaryCallable<GetNetworkHttpRequest, Network> getNetworkCallable;
    private final UnaryCallable<InsertNetworkHttpRequest, Operation> insertNetworkCallable;
    private final UnaryCallable<ListNetworksHttpRequest, NetworkList> listNetworksCallable;
    private final UnaryCallable<ListNetworksHttpRequest, NetworkClient.ListNetworksPagedResponse> listNetworksPagedCallable;
    private final UnaryCallable<PatchNetworkHttpRequest, Operation> patchNetworkCallable;
    private final UnaryCallable<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkCallable;
    private final UnaryCallable<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonNetworkStub create(NetworkStubSettings settings) throws IOException {
        return new HttpJsonNetworkStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonNetworkStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonNetworkStub(NetworkStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonNetworkStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonNetworkStub(NetworkStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonNetworkStub(NetworkStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonNetworkCallableFactory());
    }

    protected HttpJsonNetworkStub(NetworkStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings addPeeringNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addPeeringNetworkMethodDescriptor).build();
        HttpJsonCallSettings deleteNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteNetworkMethodDescriptor).build();
        HttpJsonCallSettings getNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getNetworkMethodDescriptor).build();
        HttpJsonCallSettings insertNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertNetworkMethodDescriptor).build();
        HttpJsonCallSettings listNetworksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listNetworksMethodDescriptor).build();
        HttpJsonCallSettings patchNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchNetworkMethodDescriptor).build();
        HttpJsonCallSettings removePeeringNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removePeeringNetworkMethodDescriptor).build();
        HttpJsonCallSettings switchToCustomModeNetworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(switchToCustomModeNetworkMethodDescriptor).build();
        this.addPeeringNetworkCallable = callableFactory.createUnaryCallable(addPeeringNetworkTransportSettings, settings.addPeeringNetworkSettings(), clientContext);
        this.deleteNetworkCallable = callableFactory.createUnaryCallable(deleteNetworkTransportSettings, settings.deleteNetworkSettings(), clientContext);
        this.getNetworkCallable = callableFactory.createUnaryCallable(getNetworkTransportSettings, settings.getNetworkSettings(), clientContext);
        this.insertNetworkCallable = callableFactory.createUnaryCallable(insertNetworkTransportSettings, settings.insertNetworkSettings(), clientContext);
        this.listNetworksCallable = callableFactory.createUnaryCallable(listNetworksTransportSettings, settings.listNetworksSettings(), clientContext);
        this.listNetworksPagedCallable = callableFactory.createPagedCallable(listNetworksTransportSettings, settings.listNetworksSettings(), clientContext);
        this.patchNetworkCallable = callableFactory.createUnaryCallable(patchNetworkTransportSettings, settings.patchNetworkSettings(), clientContext);
        this.removePeeringNetworkCallable = callableFactory.createUnaryCallable(removePeeringNetworkTransportSettings, settings.removePeeringNetworkSettings(), clientContext);
        this.switchToCustomModeNetworkCallable = callableFactory.createUnaryCallable(switchToCustomModeNetworkTransportSettings, settings.switchToCustomModeNetworkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkCallable() {
        return this.addPeeringNetworkCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteNetworkHttpRequest, Operation> deleteNetworkCallable() {
        return this.deleteNetworkCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetNetworkHttpRequest, Network> getNetworkCallable() {
        return this.getNetworkCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertNetworkHttpRequest, Operation> insertNetworkCallable() {
        return this.insertNetworkCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListNetworksHttpRequest, NetworkClient.ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.listNetworksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListNetworksHttpRequest, NetworkList> listNetworksCallable() {
        return this.listNetworksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchNetworkHttpRequest, Operation> patchNetworkCallable() {
        return this.patchNetworkCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkCallable() {
        return this.removePeeringNetworkCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkCallable() {
        return this.switchToCustomModeNetworkCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

