/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalLicenseCodeName
implements ResourceName {
    private final String licenseCode;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/licenseCodes/{licenseCode}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalLicenseCodeName(Builder builder) {
        this.licenseCode = (String)Preconditions.checkNotNull((Object)builder.getLicenseCode());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalLicenseCodeName of(String licenseCode, String project) {
        return ProjectGlobalLicenseCodeName.newBuilder().setLicenseCode(licenseCode).setProject(project).build();
    }

    public static String format(String licenseCode, String project) {
        return ProjectGlobalLicenseCodeName.of(licenseCode, project).toString();
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalLicenseCodeName projectGlobalLicenseCodeName = this;
            synchronized (projectGlobalLicenseCodeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"licenseCode", (Object)this.licenseCode);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalLicenseCodeName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalLicenseCodeName>(){

            public ProjectGlobalLicenseCodeName parse(String formattedString) {
                return ProjectGlobalLicenseCodeName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalLicenseCodeName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalLicenseCodeName.parse: formattedString not in valid format");
        return ProjectGlobalLicenseCodeName.of((String)matchMap.get("licenseCode"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"licenseCode", this.licenseCode, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalLicenseCodeName) {
            ProjectGlobalLicenseCodeName that = (ProjectGlobalLicenseCodeName)o;
            return Objects.equals(this.licenseCode, that.getLicenseCode()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.licenseCode, this.project);
    }

    public static class Builder {
        private String licenseCode;
        private String project;

        public String getLicenseCode() {
            return this.licenseCode;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setLicenseCode(String licenseCode) {
            this.licenseCode = licenseCode;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalLicenseCodeName projectGlobalLicenseCodeName) {
            this.licenseCode = projectGlobalLicenseCodeName.licenseCode;
            this.project = projectGlobalLicenseCodeName.project;
        }

        public ProjectGlobalLicenseCodeName build() {
            return new ProjectGlobalLicenseCodeName(this);
        }
    }
}

