/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpHealthCheck
implements ApiMessage {
    private final String host;
    private final Integer port;
    private final String portName;
    private final String portSpecification;
    private final String proxyHeader;
    private final String requestPath;
    private final String response;
    private static final HttpHealthCheck DEFAULT_INSTANCE = new HttpHealthCheck();

    private HttpHealthCheck() {
        this.host = null;
        this.port = null;
        this.portName = null;
        this.portSpecification = null;
        this.proxyHeader = null;
        this.requestPath = null;
        this.response = null;
    }

    private HttpHealthCheck(String host, Integer port, String portName, String portSpecification, String proxyHeader, String requestPath, String response) {
        this.host = host;
        this.port = port;
        this.portName = portName;
        this.portSpecification = portSpecification;
        this.proxyHeader = proxyHeader;
        this.requestPath = requestPath;
        this.response = response;
    }

    public Object getFieldValue(String fieldName) {
        if ("host".equals(fieldName)) {
            return this.host;
        }
        if ("port".equals(fieldName)) {
            return this.port;
        }
        if ("portName".equals(fieldName)) {
            return this.portName;
        }
        if ("portSpecification".equals(fieldName)) {
            return this.portSpecification;
        }
        if ("proxyHeader".equals(fieldName)) {
            return this.proxyHeader;
        }
        if ("requestPath".equals(fieldName)) {
            return this.requestPath;
        }
        if ("response".equals(fieldName)) {
            return this.response;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getPortSpecification() {
        return this.portSpecification;
    }

    public String getProxyHeader() {
        return this.proxyHeader;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getResponse() {
        return this.response;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpHealthCheck prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpHealthCheck getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpHealthCheck{host=" + this.host + ", port=" + this.port + ", portName=" + this.portName + ", portSpecification=" + this.portSpecification + ", proxyHeader=" + this.proxyHeader + ", requestPath=" + this.requestPath + ", response=" + this.response + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpHealthCheck) {
            HttpHealthCheck that = (HttpHealthCheck)o;
            return Objects.equals(this.host, that.getHost()) && Objects.equals(this.port, that.getPort()) && Objects.equals(this.portName, that.getPortName()) && Objects.equals(this.portSpecification, that.getPortSpecification()) && Objects.equals(this.proxyHeader, that.getProxyHeader()) && Objects.equals(this.requestPath, that.getRequestPath()) && Objects.equals(this.response, that.getResponse());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.portName, this.portSpecification, this.proxyHeader, this.requestPath, this.response);
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String portName;
        private String portSpecification;
        private String proxyHeader;
        private String requestPath;
        private String response;

        Builder() {
        }

        public Builder mergeFrom(HttpHealthCheck other) {
            if (other == HttpHealthCheck.getDefaultInstance()) {
                return this;
            }
            if (other.getHost() != null) {
                this.host = other.host;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            if (other.getPortName() != null) {
                this.portName = other.portName;
            }
            if (other.getPortSpecification() != null) {
                this.portSpecification = other.portSpecification;
            }
            if (other.getProxyHeader() != null) {
                this.proxyHeader = other.proxyHeader;
            }
            if (other.getRequestPath() != null) {
                this.requestPath = other.requestPath;
            }
            if (other.getResponse() != null) {
                this.response = other.response;
            }
            return this;
        }

        Builder(HttpHealthCheck source) {
            this.host = source.host;
            this.port = source.port;
            this.portName = source.portName;
            this.portSpecification = source.portSpecification;
            this.proxyHeader = source.proxyHeader;
            this.requestPath = source.requestPath;
            this.response = source.response;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public String getPortName() {
            return this.portName;
        }

        public Builder setPortName(String portName) {
            this.portName = portName;
            return this;
        }

        public String getPortSpecification() {
            return this.portSpecification;
        }

        public Builder setPortSpecification(String portSpecification) {
            this.portSpecification = portSpecification;
            return this;
        }

        public String getProxyHeader() {
            return this.proxyHeader;
        }

        public Builder setProxyHeader(String proxyHeader) {
            this.proxyHeader = proxyHeader;
            return this;
        }

        public String getRequestPath() {
            return this.requestPath;
        }

        public Builder setRequestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public String getResponse() {
            return this.response;
        }

        public Builder setResponse(String response) {
            this.response = response;
            return this;
        }

        public HttpHealthCheck build() {
            return new HttpHealthCheck(this.host, this.port, this.portName, this.portSpecification, this.proxyHeader, this.requestPath, this.response);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHost(this.host);
            newBuilder.setPort(this.port);
            newBuilder.setPortName(this.portName);
            newBuilder.setPortSpecification(this.portSpecification);
            newBuilder.setProxyHeader(this.proxyHeader);
            newBuilder.setRequestPath(this.requestPath);
            newBuilder.setResponse(this.response);
            return newBuilder;
        }
    }
}

