/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListMachineTypesHttpRequest;
import com.google.cloud.compute.v1.GetMachineTypeHttpRequest;
import com.google.cloud.compute.v1.ListMachineTypesHttpRequest;
import com.google.cloud.compute.v1.MachineType;
import com.google.cloud.compute.v1.MachineTypeAggregatedList;
import com.google.cloud.compute.v1.MachineTypeClient;
import com.google.cloud.compute.v1.MachineTypeList;
import com.google.cloud.compute.v1.MachineTypesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonMachineTypeStub;
import com.google.cloud.compute.v1.stub.MachineTypeStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MachineTypeStubSettings
extends StubSettings<MachineTypeStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypeClient.AggregatedListMachineTypesPagedResponse> aggregatedListMachineTypesSettings;
    private final UnaryCallSettings<GetMachineTypeHttpRequest, MachineType> getMachineTypeSettings;
    private final PagedCallSettings<ListMachineTypesHttpRequest, MachineTypeList, MachineTypeClient.ListMachineTypesPagedResponse> listMachineTypesSettings;
    private static final PagedListDescriptor<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList> AGGREGATED_LIST_MACHINE_TYPES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListMachineTypesHttpRequest injectToken(AggregatedListMachineTypesHttpRequest payload, String token) {
            return AggregatedListMachineTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListMachineTypesHttpRequest injectPageSize(AggregatedListMachineTypesHttpRequest payload, int pageSize) {
            return AggregatedListMachineTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListMachineTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(MachineTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MachineTypesScopedList> extractResources(MachineTypeAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListMachineTypesHttpRequest, MachineTypeList, MachineType> LIST_MACHINE_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListMachineTypesHttpRequest, MachineTypeList, MachineType>(){

        public String emptyToken() {
            return "";
        }

        public ListMachineTypesHttpRequest injectToken(ListMachineTypesHttpRequest payload, String token) {
            return ListMachineTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListMachineTypesHttpRequest injectPageSize(ListMachineTypesHttpRequest payload, int pageSize) {
            return ListMachineTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListMachineTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(MachineTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MachineType> extractResources(MachineTypeList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypeClient.AggregatedListMachineTypesPagedResponse> AGGREGATED_LIST_MACHINE_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypeClient.AggregatedListMachineTypesPagedResponse>(){

        public ApiFuture<MachineTypeClient.AggregatedListMachineTypesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList> callable, AggregatedListMachineTypesHttpRequest request, ApiCallContext context, ApiFuture<MachineTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_MACHINE_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MachineTypeClient.AggregatedListMachineTypesPagedResponse.createAsync((PageContext<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMachineTypesHttpRequest, MachineTypeList, MachineTypeClient.ListMachineTypesPagedResponse> LIST_MACHINE_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListMachineTypesHttpRequest, MachineTypeList, MachineTypeClient.ListMachineTypesPagedResponse>(){

        public ApiFuture<MachineTypeClient.ListMachineTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMachineTypesHttpRequest, MachineTypeList> callable, ListMachineTypesHttpRequest request, ApiCallContext context, ApiFuture<MachineTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MACHINE_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MachineTypeClient.ListMachineTypesPagedResponse.createAsync((PageContext<ListMachineTypesHttpRequest, MachineTypeList, MachineType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypeClient.AggregatedListMachineTypesPagedResponse> aggregatedListMachineTypesSettings() {
        return this.aggregatedListMachineTypesSettings;
    }

    public UnaryCallSettings<GetMachineTypeHttpRequest, MachineType> getMachineTypeSettings() {
        return this.getMachineTypeSettings;
    }

    public PagedCallSettings<ListMachineTypesHttpRequest, MachineTypeList, MachineTypeClient.ListMachineTypesPagedResponse> listMachineTypesSettings() {
        return this.listMachineTypesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MachineTypeStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMachineTypeStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MachineTypeStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MachineTypeStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MachineTypeStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListMachineTypesSettings = settingsBuilder.aggregatedListMachineTypesSettings().build();
        this.getMachineTypeSettings = settingsBuilder.getMachineTypeSettings().build();
        this.listMachineTypesSettings = settingsBuilder.listMachineTypesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MachineTypeStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypeClient.AggregatedListMachineTypesPagedResponse> aggregatedListMachineTypesSettings;
        private final UnaryCallSettings.Builder<GetMachineTypeHttpRequest, MachineType> getMachineTypeSettings;
        private final PagedCallSettings.Builder<ListMachineTypesHttpRequest, MachineTypeList, MachineTypeClient.ListMachineTypesPagedResponse> listMachineTypesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListMachineTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_MACHINE_TYPES_PAGE_STR_FACT);
            this.getMachineTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMachineTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MACHINE_TYPES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListMachineTypesSettings, this.getMachineTypeSettings, this.listMachineTypesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MachineTypeStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MachineTypeStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MachineTypeStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MachineTypeStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListMachineTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getMachineTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listMachineTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(MachineTypeStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListMachineTypesSettings = settings.aggregatedListMachineTypesSettings.toBuilder();
            this.getMachineTypeSettings = settings.getMachineTypeSettings.toBuilder();
            this.listMachineTypesSettings = settings.listMachineTypesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListMachineTypesSettings, this.getMachineTypeSettings, this.listMachineTypesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypeClient.AggregatedListMachineTypesPagedResponse> aggregatedListMachineTypesSettings() {
            return this.aggregatedListMachineTypesSettings;
        }

        public UnaryCallSettings.Builder<GetMachineTypeHttpRequest, MachineType> getMachineTypeSettings() {
            return this.getMachineTypeSettings;
        }

        public PagedCallSettings.Builder<ListMachineTypesHttpRequest, MachineTypeList, MachineTypeClient.ListMachineTypesPagedResponse> listMachineTypesSettings() {
            return this.listMachineTypesSettings;
        }

        public MachineTypeStubSettings build() throws IOException {
            return new MachineTypeStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

