/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ShieldedInstanceConfig
implements ApiMessage {
    private final Boolean enableIntegrityMonitoring;
    private final Boolean enableSecureBoot;
    private final Boolean enableVtpm;
    private static final ShieldedInstanceConfig DEFAULT_INSTANCE = new ShieldedInstanceConfig();

    private ShieldedInstanceConfig() {
        this.enableIntegrityMonitoring = null;
        this.enableSecureBoot = null;
        this.enableVtpm = null;
    }

    private ShieldedInstanceConfig(Boolean enableIntegrityMonitoring, Boolean enableSecureBoot, Boolean enableVtpm) {
        this.enableIntegrityMonitoring = enableIntegrityMonitoring;
        this.enableSecureBoot = enableSecureBoot;
        this.enableVtpm = enableVtpm;
    }

    public Object getFieldValue(String fieldName) {
        if ("enableIntegrityMonitoring".equals(fieldName)) {
            return this.enableIntegrityMonitoring;
        }
        if ("enableSecureBoot".equals(fieldName)) {
            return this.enableSecureBoot;
        }
        if ("enableVtpm".equals(fieldName)) {
            return this.enableVtpm;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getEnableIntegrityMonitoring() {
        return this.enableIntegrityMonitoring;
    }

    public Boolean getEnableSecureBoot() {
        return this.enableSecureBoot;
    }

    public Boolean getEnableVtpm() {
        return this.enableVtpm;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ShieldedInstanceConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ShieldedInstanceConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ShieldedInstanceConfig{enableIntegrityMonitoring=" + this.enableIntegrityMonitoring + ", enableSecureBoot=" + this.enableSecureBoot + ", enableVtpm=" + this.enableVtpm + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShieldedInstanceConfig) {
            ShieldedInstanceConfig that = (ShieldedInstanceConfig)o;
            return Objects.equals(this.enableIntegrityMonitoring, that.getEnableIntegrityMonitoring()) && Objects.equals(this.enableSecureBoot, that.getEnableSecureBoot()) && Objects.equals(this.enableVtpm, that.getEnableVtpm());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.enableIntegrityMonitoring, this.enableSecureBoot, this.enableVtpm);
    }

    public static class Builder {
        private Boolean enableIntegrityMonitoring;
        private Boolean enableSecureBoot;
        private Boolean enableVtpm;

        Builder() {
        }

        public Builder mergeFrom(ShieldedInstanceConfig other) {
            if (other == ShieldedInstanceConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getEnableIntegrityMonitoring() != null) {
                this.enableIntegrityMonitoring = other.enableIntegrityMonitoring;
            }
            if (other.getEnableSecureBoot() != null) {
                this.enableSecureBoot = other.enableSecureBoot;
            }
            if (other.getEnableVtpm() != null) {
                this.enableVtpm = other.enableVtpm;
            }
            return this;
        }

        Builder(ShieldedInstanceConfig source) {
            this.enableIntegrityMonitoring = source.enableIntegrityMonitoring;
            this.enableSecureBoot = source.enableSecureBoot;
            this.enableVtpm = source.enableVtpm;
        }

        public Boolean getEnableIntegrityMonitoring() {
            return this.enableIntegrityMonitoring;
        }

        public Builder setEnableIntegrityMonitoring(Boolean enableIntegrityMonitoring) {
            this.enableIntegrityMonitoring = enableIntegrityMonitoring;
            return this;
        }

        public Boolean getEnableSecureBoot() {
            return this.enableSecureBoot;
        }

        public Builder setEnableSecureBoot(Boolean enableSecureBoot) {
            this.enableSecureBoot = enableSecureBoot;
            return this;
        }

        public Boolean getEnableVtpm() {
            return this.enableVtpm;
        }

        public Builder setEnableVtpm(Boolean enableVtpm) {
            this.enableVtpm = enableVtpm;
            return this;
        }

        public ShieldedInstanceConfig build() {
            return new ShieldedInstanceConfig(this.enableIntegrityMonitoring, this.enableSecureBoot, this.enableVtpm);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEnableIntegrityMonitoring(this.enableIntegrityMonitoring);
            newBuilder.setEnableSecureBoot(this.enableSecureBoot);
            newBuilder.setEnableVtpm(this.enableVtpm);
            return newBuilder;
        }
    }
}

