/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.CreateSnapshotRegionDiskHttpRequest;
import com.google.cloud.compute.v1.DeleteRegionDiskHttpRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.GetRegionDiskHttpRequest;
import com.google.cloud.compute.v1.InsertRegionDiskHttpRequest;
import com.google.cloud.compute.v1.ListRegionDisksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionDiskName;
import com.google.cloud.compute.v1.ProjectRegionDiskResourceName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionDiskSettings;
import com.google.cloud.compute.v1.RegionDisksResizeRequest;
import com.google.cloud.compute.v1.RegionSetLabelsRequest;
import com.google.cloud.compute.v1.ResizeRegionDiskHttpRequest;
import com.google.cloud.compute.v1.SetLabelsRegionDiskHttpRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.TestIamPermissionsRegionDiskHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.RegionDiskStub;
import com.google.cloud.compute.v1.stub.RegionDiskStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionDiskClient
implements BackgroundResource {
    private final RegionDiskSettings settings;
    private final RegionDiskStub stub;

    public static final RegionDiskClient create() throws IOException {
        return RegionDiskClient.create(RegionDiskSettings.newBuilder().build());
    }

    public static final RegionDiskClient create(RegionDiskSettings settings) throws IOException {
        return new RegionDiskClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionDiskClient create(RegionDiskStub stub) {
        return new RegionDiskClient(stub);
    }

    protected RegionDiskClient(RegionDiskSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionDiskStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionDiskClient(RegionDiskStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionDiskSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionDiskStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation createSnapshotRegionDisk(ProjectRegionDiskName disk, Snapshot snapshotResource) {
        CreateSnapshotRegionDiskHttpRequest request = CreateSnapshotRegionDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).setSnapshotResource(snapshotResource).build();
        return this.createSnapshotRegionDisk(request);
    }

    @BetaApi
    public final Operation createSnapshotRegionDisk(String disk, Snapshot snapshotResource) {
        CreateSnapshotRegionDiskHttpRequest request = CreateSnapshotRegionDiskHttpRequest.newBuilder().setDisk(disk).setSnapshotResource(snapshotResource).build();
        return this.createSnapshotRegionDisk(request);
    }

    @BetaApi
    public final Operation createSnapshotRegionDisk(CreateSnapshotRegionDiskHttpRequest request) {
        return (Operation)this.createSnapshotRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<CreateSnapshotRegionDiskHttpRequest, Operation> createSnapshotRegionDiskCallable() {
        return this.stub.createSnapshotRegionDiskCallable();
    }

    @BetaApi
    public final Operation deleteRegionDisk(ProjectRegionDiskName disk) {
        DeleteRegionDiskHttpRequest request = DeleteRegionDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).build();
        return this.deleteRegionDisk(request);
    }

    @BetaApi
    public final Operation deleteRegionDisk(String disk) {
        DeleteRegionDiskHttpRequest request = DeleteRegionDiskHttpRequest.newBuilder().setDisk(disk).build();
        return this.deleteRegionDisk(request);
    }

    @BetaApi
    public final Operation deleteRegionDisk(DeleteRegionDiskHttpRequest request) {
        return (Operation)this.deleteRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionDiskHttpRequest, Operation> deleteRegionDiskCallable() {
        return this.stub.deleteRegionDiskCallable();
    }

    @BetaApi
    public final Disk getRegionDisk(ProjectRegionDiskName disk) {
        GetRegionDiskHttpRequest request = GetRegionDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).build();
        return this.getRegionDisk(request);
    }

    @BetaApi
    public final Disk getRegionDisk(String disk) {
        GetRegionDiskHttpRequest request = GetRegionDiskHttpRequest.newBuilder().setDisk(disk).build();
        return this.getRegionDisk(request);
    }

    @BetaApi
    public final Disk getRegionDisk(GetRegionDiskHttpRequest request) {
        return (Disk)this.getRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionDiskHttpRequest, Disk> getRegionDiskCallable() {
        return this.stub.getRegionDiskCallable();
    }

    @BetaApi
    public final Operation insertRegionDisk(ProjectRegionName region, Disk diskResource) {
        InsertRegionDiskHttpRequest request = InsertRegionDiskHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setDiskResource(diskResource).build();
        return this.insertRegionDisk(request);
    }

    @BetaApi
    public final Operation insertRegionDisk(String region, Disk diskResource) {
        InsertRegionDiskHttpRequest request = InsertRegionDiskHttpRequest.newBuilder().setRegion(region).setDiskResource(diskResource).build();
        return this.insertRegionDisk(request);
    }

    @BetaApi
    public final Operation insertRegionDisk(InsertRegionDiskHttpRequest request) {
        return (Operation)this.insertRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionDiskHttpRequest, Operation> insertRegionDiskCallable() {
        return this.stub.insertRegionDiskCallable();
    }

    @BetaApi
    public final ListRegionDisksPagedResponse listRegionDisks(ProjectRegionName region) {
        ListRegionDisksHttpRequest request = ListRegionDisksHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionDisks(request);
    }

    @BetaApi
    public final ListRegionDisksPagedResponse listRegionDisks(String region) {
        ListRegionDisksHttpRequest request = ListRegionDisksHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionDisks(request);
    }

    @BetaApi
    public final ListRegionDisksPagedResponse listRegionDisks(ListRegionDisksHttpRequest request) {
        return (ListRegionDisksPagedResponse)((Object)this.listRegionDisksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionDisksHttpRequest, ListRegionDisksPagedResponse> listRegionDisksPagedCallable() {
        return this.stub.listRegionDisksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionDisksHttpRequest, DiskList> listRegionDisksCallable() {
        return this.stub.listRegionDisksCallable();
    }

    @BetaApi
    public final Operation resizeRegionDisk(ProjectRegionDiskName disk, RegionDisksResizeRequest regionDisksResizeRequestResource) {
        ResizeRegionDiskHttpRequest request = ResizeRegionDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).setRegionDisksResizeRequestResource(regionDisksResizeRequestResource).build();
        return this.resizeRegionDisk(request);
    }

    @BetaApi
    public final Operation resizeRegionDisk(String disk, RegionDisksResizeRequest regionDisksResizeRequestResource) {
        ResizeRegionDiskHttpRequest request = ResizeRegionDiskHttpRequest.newBuilder().setDisk(disk).setRegionDisksResizeRequestResource(regionDisksResizeRequestResource).build();
        return this.resizeRegionDisk(request);
    }

    @BetaApi
    public final Operation resizeRegionDisk(ResizeRegionDiskHttpRequest request) {
        return (Operation)this.resizeRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ResizeRegionDiskHttpRequest, Operation> resizeRegionDiskCallable() {
        return this.stub.resizeRegionDiskCallable();
    }

    @BetaApi
    public final Operation setLabelsRegionDisk(ProjectRegionDiskResourceName resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsRegionDiskHttpRequest request = SetLabelsRegionDiskHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabelsRegionDisk(request);
    }

    @BetaApi
    public final Operation setLabelsRegionDisk(String resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsRegionDiskHttpRequest request = SetLabelsRegionDiskHttpRequest.newBuilder().setResource(resource).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabelsRegionDisk(request);
    }

    @BetaApi
    public final Operation setLabelsRegionDisk(SetLabelsRegionDiskHttpRequest request) {
        return (Operation)this.setLabelsRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetLabelsRegionDiskHttpRequest, Operation> setLabelsRegionDiskCallable() {
        return this.stub.setLabelsRegionDiskCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsRegionDisk(ProjectRegionDiskResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsRegionDiskHttpRequest request = TestIamPermissionsRegionDiskHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsRegionDisk(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsRegionDisk(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsRegionDiskHttpRequest request = TestIamPermissionsRegionDiskHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsRegionDisk(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsRegionDisk(TestIamPermissionsRegionDiskHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsRegionDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsRegionDiskHttpRequest, TestPermissionsResponse> testIamPermissionsRegionDiskCallable() {
        return this.stub.testIamPermissionsRegionDiskCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionDisksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionDisksHttpRequest, DiskList, Disk, ListRegionDisksPage, ListRegionDisksFixedSizeCollection> {
        private ListRegionDisksFixedSizeCollection(List<ListRegionDisksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionDisksFixedSizeCollection createEmptyCollection() {
            return new ListRegionDisksFixedSizeCollection(null, 0);
        }

        protected ListRegionDisksFixedSizeCollection createCollection(List<ListRegionDisksPage> pages, int collectionSize) {
            return new ListRegionDisksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionDisksPage
    extends AbstractPage<ListRegionDisksHttpRequest, DiskList, Disk, ListRegionDisksPage> {
        private ListRegionDisksPage(PageContext<ListRegionDisksHttpRequest, DiskList, Disk> context, DiskList response) {
            super(context, (Object)response);
        }

        private static ListRegionDisksPage createEmptyPage() {
            return new ListRegionDisksPage(null, null);
        }

        protected ListRegionDisksPage createPage(PageContext<ListRegionDisksHttpRequest, DiskList, Disk> context, DiskList response) {
            return new ListRegionDisksPage(context, response);
        }

        public ApiFuture<ListRegionDisksPage> createPageAsync(PageContext<ListRegionDisksHttpRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionDisksPagedResponse
    extends AbstractPagedListResponse<ListRegionDisksHttpRequest, DiskList, Disk, ListRegionDisksPage, ListRegionDisksFixedSizeCollection> {
        public static ApiFuture<ListRegionDisksPagedResponse> createAsync(PageContext<ListRegionDisksHttpRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            ApiFuture<ListRegionDisksPage> futurePage = ListRegionDisksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionDisksPage, ListRegionDisksPagedResponse>(){

                public ListRegionDisksPagedResponse apply(ListRegionDisksPage input) {
                    return new ListRegionDisksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionDisksPagedResponse(ListRegionDisksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionDisksFixedSizeCollection.createEmptyCollection());
        }
    }
}

