/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendBucketHttpRequest;
import com.google.cloud.compute.v1.BackendBucket;
import com.google.cloud.compute.v1.BackendBucketClient;
import com.google.cloud.compute.v1.BackendBucketList;
import com.google.cloud.compute.v1.DeleteBackendBucketHttpRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendBucketHttpRequest;
import com.google.cloud.compute.v1.GetBackendBucketHttpRequest;
import com.google.cloud.compute.v1.InsertBackendBucketHttpRequest;
import com.google.cloud.compute.v1.ListBackendBucketsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendBucketHttpRequest;
import com.google.cloud.compute.v1.UpdateBackendBucketHttpRequest;
import com.google.cloud.compute.v1.stub.BackendBucketStub;
import com.google.cloud.compute.v1.stub.HttpJsonBackendBucketStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BackendBucketStubSettings
extends StubSettings<BackendBucketStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddSignedUrlKeyBackendBucketHttpRequest, Operation> addSignedUrlKeyBackendBucketSettings;
    private final UnaryCallSettings<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketSettings;
    private final UnaryCallSettings<DeleteSignedUrlKeyBackendBucketHttpRequest, Operation> deleteSignedUrlKeyBackendBucketSettings;
    private final UnaryCallSettings<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketSettings;
    private final UnaryCallSettings<InsertBackendBucketHttpRequest, Operation> insertBackendBucketSettings;
    private final PagedCallSettings<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucketClient.ListBackendBucketsPagedResponse> listBackendBucketsSettings;
    private final UnaryCallSettings<PatchBackendBucketHttpRequest, Operation> patchBackendBucketSettings;
    private final UnaryCallSettings<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketSettings;
    private static final PagedListDescriptor<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket> LIST_BACKEND_BUCKETS_PAGE_STR_DESC = new PagedListDescriptor<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket>(){

        public String emptyToken() {
            return "";
        }

        public ListBackendBucketsHttpRequest injectToken(ListBackendBucketsHttpRequest payload, String token) {
            return ListBackendBucketsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListBackendBucketsHttpRequest injectPageSize(ListBackendBucketsHttpRequest payload, int pageSize) {
            return ListBackendBucketsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListBackendBucketsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendBucketList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendBucket> extractResources(BackendBucketList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucketClient.ListBackendBucketsPagedResponse> LIST_BACKEND_BUCKETS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucketClient.ListBackendBucketsPagedResponse>(){

        public ApiFuture<BackendBucketClient.ListBackendBucketsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackendBucketsHttpRequest, BackendBucketList> callable, ListBackendBucketsHttpRequest request, ApiCallContext context, ApiFuture<BackendBucketList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKEND_BUCKETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendBucketClient.ListBackendBucketsPagedResponse.createAsync((PageContext<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddSignedUrlKeyBackendBucketHttpRequest, Operation> addSignedUrlKeyBackendBucketSettings() {
        return this.addSignedUrlKeyBackendBucketSettings;
    }

    public UnaryCallSettings<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketSettings() {
        return this.deleteBackendBucketSettings;
    }

    public UnaryCallSettings<DeleteSignedUrlKeyBackendBucketHttpRequest, Operation> deleteSignedUrlKeyBackendBucketSettings() {
        return this.deleteSignedUrlKeyBackendBucketSettings;
    }

    public UnaryCallSettings<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketSettings() {
        return this.getBackendBucketSettings;
    }

    public UnaryCallSettings<InsertBackendBucketHttpRequest, Operation> insertBackendBucketSettings() {
        return this.insertBackendBucketSettings;
    }

    public PagedCallSettings<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucketClient.ListBackendBucketsPagedResponse> listBackendBucketsSettings() {
        return this.listBackendBucketsSettings;
    }

    public UnaryCallSettings<PatchBackendBucketHttpRequest, Operation> patchBackendBucketSettings() {
        return this.patchBackendBucketSettings;
    }

    public UnaryCallSettings<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketSettings() {
        return this.updateBackendBucketSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BackendBucketStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBackendBucketStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BackendBucketStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackendBucketStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BackendBucketStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addSignedUrlKeyBackendBucketSettings = settingsBuilder.addSignedUrlKeyBackendBucketSettings().build();
        this.deleteBackendBucketSettings = settingsBuilder.deleteBackendBucketSettings().build();
        this.deleteSignedUrlKeyBackendBucketSettings = settingsBuilder.deleteSignedUrlKeyBackendBucketSettings().build();
        this.getBackendBucketSettings = settingsBuilder.getBackendBucketSettings().build();
        this.insertBackendBucketSettings = settingsBuilder.insertBackendBucketSettings().build();
        this.listBackendBucketsSettings = settingsBuilder.listBackendBucketsSettings().build();
        this.patchBackendBucketSettings = settingsBuilder.patchBackendBucketSettings().build();
        this.updateBackendBucketSettings = settingsBuilder.updateBackendBucketSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BackendBucketStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddSignedUrlKeyBackendBucketHttpRequest, Operation> addSignedUrlKeyBackendBucketSettings;
        private final UnaryCallSettings.Builder<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketSettings;
        private final UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendBucketHttpRequest, Operation> deleteSignedUrlKeyBackendBucketSettings;
        private final UnaryCallSettings.Builder<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketSettings;
        private final UnaryCallSettings.Builder<InsertBackendBucketHttpRequest, Operation> insertBackendBucketSettings;
        private final PagedCallSettings.Builder<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucketClient.ListBackendBucketsPagedResponse> listBackendBucketsSettings;
        private final UnaryCallSettings.Builder<PatchBackendBucketHttpRequest, Operation> patchBackendBucketSettings;
        private final UnaryCallSettings.Builder<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addSignedUrlKeyBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSignedUrlKeyBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBackendBucketsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKEND_BUCKETS_PAGE_STR_FACT);
            this.patchBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackendBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeyBackendBucketSettings, this.deleteBackendBucketSettings, this.deleteSignedUrlKeyBackendBucketSettings, this.getBackendBucketSettings, this.insertBackendBucketSettings, this.listBackendBucketsSettings, this.patchBackendBucketSettings, this.updateBackendBucketSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BackendBucketStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BackendBucketStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackendBucketStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BackendBucketStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addSignedUrlKeyBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSignedUrlKeyBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listBackendBucketsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateBackendBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(BackendBucketStubSettings settings) {
            super((StubSettings)settings);
            this.addSignedUrlKeyBackendBucketSettings = settings.addSignedUrlKeyBackendBucketSettings.toBuilder();
            this.deleteBackendBucketSettings = settings.deleteBackendBucketSettings.toBuilder();
            this.deleteSignedUrlKeyBackendBucketSettings = settings.deleteSignedUrlKeyBackendBucketSettings.toBuilder();
            this.getBackendBucketSettings = settings.getBackendBucketSettings.toBuilder();
            this.insertBackendBucketSettings = settings.insertBackendBucketSettings.toBuilder();
            this.listBackendBucketsSettings = settings.listBackendBucketsSettings.toBuilder();
            this.patchBackendBucketSettings = settings.patchBackendBucketSettings.toBuilder();
            this.updateBackendBucketSettings = settings.updateBackendBucketSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeyBackendBucketSettings, this.deleteBackendBucketSettings, this.deleteSignedUrlKeyBackendBucketSettings, this.getBackendBucketSettings, this.insertBackendBucketSettings, this.listBackendBucketsSettings, this.patchBackendBucketSettings, this.updateBackendBucketSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddSignedUrlKeyBackendBucketHttpRequest, Operation> addSignedUrlKeyBackendBucketSettings() {
            return this.addSignedUrlKeyBackendBucketSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketSettings() {
            return this.deleteBackendBucketSettings;
        }

        public UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendBucketHttpRequest, Operation> deleteSignedUrlKeyBackendBucketSettings() {
            return this.deleteSignedUrlKeyBackendBucketSettings;
        }

        public UnaryCallSettings.Builder<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketSettings() {
            return this.getBackendBucketSettings;
        }

        public UnaryCallSettings.Builder<InsertBackendBucketHttpRequest, Operation> insertBackendBucketSettings() {
            return this.insertBackendBucketSettings;
        }

        public PagedCallSettings.Builder<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucketClient.ListBackendBucketsPagedResponse> listBackendBucketsSettings() {
            return this.listBackendBucketsSettings;
        }

        public UnaryCallSettings.Builder<PatchBackendBucketHttpRequest, Operation> patchBackendBucketSettings() {
            return this.patchBackendBucketSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketSettings() {
            return this.updateBackendBucketSettings;
        }

        public BackendBucketStubSettings build() throws IOException {
            return new BackendBucketStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

