/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Tags
implements ApiMessage {
    private final String fingerprint;
    private final List<String> items;
    private static final Tags DEFAULT_INSTANCE = new Tags();

    private Tags() {
        this.fingerprint = null;
        this.items = null;
    }

    private Tags(String fingerprint, List<String> items) {
        this.fingerprint = fingerprint;
        this.items = items;
    }

    public Object getFieldValue(String fieldName) {
        if ("fingerprint".equals(fieldName)) {
            return this.fingerprint;
        }
        if ("items".equals(fieldName)) {
            return this.items;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public List<String> getItemsList() {
        return this.items;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Tags prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Tags getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Tags{fingerprint=" + this.fingerprint + ", items=" + this.items + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Tags) {
            Tags that = (Tags)o;
            return Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.items, that.getItemsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.items);
    }

    public static class Builder {
        private String fingerprint;
        private List<String> items;

        Builder() {
        }

        public Builder mergeFrom(Tags other) {
            if (other == Tags.getDefaultInstance()) {
                return this;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            return this;
        }

        Builder(Tags source) {
            this.fingerprint = source.fingerprint;
            this.items = source.items;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public List<String> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<String> items) {
            if (this.items == null) {
                this.items = new LinkedList<String>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(String items) {
            if (this.items == null) {
                this.items = new LinkedList<String>();
            }
            this.items.add(items);
            return this;
        }

        public Tags build() {
            return new Tags(this.fingerprint, this.items);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.addAllItems(this.items);
            return newBuilder;
        }
    }
}

