/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteSslPolicyHttpRequest;
import com.google.cloud.compute.v1.GetSslPolicyHttpRequest;
import com.google.cloud.compute.v1.InsertSslPolicyHttpRequest;
import com.google.cloud.compute.v1.ListAvailableFeaturesSslPoliciesHttpRequest;
import com.google.cloud.compute.v1.ListSslPoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSslPolicyHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalSslPolicyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SslPoliciesList;
import com.google.cloud.compute.v1.SslPoliciesListAvailableFeaturesResponse;
import com.google.cloud.compute.v1.SslPolicy;
import com.google.cloud.compute.v1.SslPolicySettings;
import com.google.cloud.compute.v1.stub.SslPolicyStub;
import com.google.cloud.compute.v1.stub.SslPolicyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SslPolicyClient
implements BackgroundResource {
    private final SslPolicySettings settings;
    private final SslPolicyStub stub;

    public static final SslPolicyClient create() throws IOException {
        return SslPolicyClient.create(SslPolicySettings.newBuilder().build());
    }

    public static final SslPolicyClient create(SslPolicySettings settings) throws IOException {
        return new SslPolicyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SslPolicyClient create(SslPolicyStub stub) {
        return new SslPolicyClient(stub);
    }

    protected SslPolicyClient(SslPolicySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SslPolicyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SslPolicyClient(SslPolicyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SslPolicySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SslPolicyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteSslPolicy(ProjectGlobalSslPolicyName sslPolicy) {
        DeleteSslPolicyHttpRequest request = DeleteSslPolicyHttpRequest.newBuilder().setSslPolicy(sslPolicy == null ? null : sslPolicy.toString()).build();
        return this.deleteSslPolicy(request);
    }

    @BetaApi
    public final Operation deleteSslPolicy(String sslPolicy) {
        DeleteSslPolicyHttpRequest request = DeleteSslPolicyHttpRequest.newBuilder().setSslPolicy(sslPolicy).build();
        return this.deleteSslPolicy(request);
    }

    @BetaApi
    public final Operation deleteSslPolicy(DeleteSslPolicyHttpRequest request) {
        return (Operation)this.deleteSslPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSslPolicyHttpRequest, Operation> deleteSslPolicyCallable() {
        return this.stub.deleteSslPolicyCallable();
    }

    @BetaApi
    public final SslPolicy getSslPolicy(ProjectGlobalSslPolicyName sslPolicy) {
        GetSslPolicyHttpRequest request = GetSslPolicyHttpRequest.newBuilder().setSslPolicy(sslPolicy == null ? null : sslPolicy.toString()).build();
        return this.getSslPolicy(request);
    }

    @BetaApi
    public final SslPolicy getSslPolicy(String sslPolicy) {
        GetSslPolicyHttpRequest request = GetSslPolicyHttpRequest.newBuilder().setSslPolicy(sslPolicy).build();
        return this.getSslPolicy(request);
    }

    @BetaApi
    public final SslPolicy getSslPolicy(GetSslPolicyHttpRequest request) {
        return (SslPolicy)this.getSslPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSslPolicyHttpRequest, SslPolicy> getSslPolicyCallable() {
        return this.stub.getSslPolicyCallable();
    }

    @BetaApi
    public final Operation insertSslPolicy(ProjectName project, SslPolicy sslPolicyResource) {
        InsertSslPolicyHttpRequest request = InsertSslPolicyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setSslPolicyResource(sslPolicyResource).build();
        return this.insertSslPolicy(request);
    }

    @BetaApi
    public final Operation insertSslPolicy(String project, SslPolicy sslPolicyResource) {
        InsertSslPolicyHttpRequest request = InsertSslPolicyHttpRequest.newBuilder().setProject(project).setSslPolicyResource(sslPolicyResource).build();
        return this.insertSslPolicy(request);
    }

    @BetaApi
    public final Operation insertSslPolicy(InsertSslPolicyHttpRequest request) {
        return (Operation)this.insertSslPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertSslPolicyHttpRequest, Operation> insertSslPolicyCallable() {
        return this.stub.insertSslPolicyCallable();
    }

    @BetaApi
    public final ListSslPoliciesPagedResponse listSslPolicies(ProjectName project) {
        ListSslPoliciesHttpRequest request = ListSslPoliciesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listSslPolicies(request);
    }

    @BetaApi
    public final ListSslPoliciesPagedResponse listSslPolicies(String project) {
        ListSslPoliciesHttpRequest request = ListSslPoliciesHttpRequest.newBuilder().setProject(project).build();
        return this.listSslPolicies(request);
    }

    @BetaApi
    public final ListSslPoliciesPagedResponse listSslPolicies(ListSslPoliciesHttpRequest request) {
        return (ListSslPoliciesPagedResponse)((Object)this.listSslPoliciesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListSslPoliciesHttpRequest, ListSslPoliciesPagedResponse> listSslPoliciesPagedCallable() {
        return this.stub.listSslPoliciesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListSslPoliciesHttpRequest, SslPoliciesList> listSslPoliciesCallable() {
        return this.stub.listSslPoliciesCallable();
    }

    @BetaApi
    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeaturesSslPolicies(ProjectName project) {
        ListAvailableFeaturesSslPoliciesHttpRequest request = ListAvailableFeaturesSslPoliciesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listAvailableFeaturesSslPolicies(request);
    }

    @BetaApi
    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeaturesSslPolicies(String project) {
        ListAvailableFeaturesSslPoliciesHttpRequest request = ListAvailableFeaturesSslPoliciesHttpRequest.newBuilder().setProject(project).build();
        return this.listAvailableFeaturesSslPolicies(request);
    }

    @BetaApi
    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeaturesSslPolicies(ListAvailableFeaturesSslPoliciesHttpRequest request) {
        return (SslPoliciesListAvailableFeaturesResponse)this.listAvailableFeaturesSslPoliciesCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ListAvailableFeaturesSslPoliciesHttpRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSslPoliciesCallable() {
        return this.stub.listAvailableFeaturesSslPoliciesCallable();
    }

    @BetaApi
    public final Operation patchSslPolicy(ProjectGlobalSslPolicyName sslPolicy, SslPolicy sslPolicyResource, List<String> fieldMask) {
        PatchSslPolicyHttpRequest request = PatchSslPolicyHttpRequest.newBuilder().setSslPolicy(sslPolicy == null ? null : sslPolicy.toString()).setSslPolicyResource(sslPolicyResource).addAllFieldMask(fieldMask).build();
        return this.patchSslPolicy(request);
    }

    @BetaApi
    public final Operation patchSslPolicy(String sslPolicy, SslPolicy sslPolicyResource, List<String> fieldMask) {
        PatchSslPolicyHttpRequest request = PatchSslPolicyHttpRequest.newBuilder().setSslPolicy(sslPolicy).setSslPolicyResource(sslPolicyResource).addAllFieldMask(fieldMask).build();
        return this.patchSslPolicy(request);
    }

    @BetaApi
    public final Operation patchSslPolicy(PatchSslPolicyHttpRequest request) {
        return (Operation)this.patchSslPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchSslPolicyHttpRequest, Operation> patchSslPolicyCallable() {
        return this.stub.patchSslPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSslPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy, ListSslPoliciesPage, ListSslPoliciesFixedSizeCollection> {
        private ListSslPoliciesFixedSizeCollection(List<ListSslPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSslPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListSslPoliciesFixedSizeCollection(null, 0);
        }

        protected ListSslPoliciesFixedSizeCollection createCollection(List<ListSslPoliciesPage> pages, int collectionSize) {
            return new ListSslPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSslPoliciesPage
    extends AbstractPage<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy, ListSslPoliciesPage> {
        private ListSslPoliciesPage(PageContext<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy> context, SslPoliciesList response) {
            super(context, (Object)response);
        }

        private static ListSslPoliciesPage createEmptyPage() {
            return new ListSslPoliciesPage(null, null);
        }

        protected ListSslPoliciesPage createPage(PageContext<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy> context, SslPoliciesList response) {
            return new ListSslPoliciesPage(context, response);
        }

        public ApiFuture<ListSslPoliciesPage> createPageAsync(PageContext<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy> context, ApiFuture<SslPoliciesList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSslPoliciesPagedResponse
    extends AbstractPagedListResponse<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy, ListSslPoliciesPage, ListSslPoliciesFixedSizeCollection> {
        public static ApiFuture<ListSslPoliciesPagedResponse> createAsync(PageContext<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy> context, ApiFuture<SslPoliciesList> futureResponse) {
            ApiFuture<ListSslPoliciesPage> futurePage = ListSslPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSslPoliciesPage, ListSslPoliciesPagedResponse>(){

                public ListSslPoliciesPagedResponse apply(ListSslPoliciesPage input) {
                    return new ListSslPoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSslPoliciesPagedResponse(ListSslPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSslPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

