/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.RouterStatus;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterStatusResponse
implements ApiMessage {
    private final String kind;
    private final RouterStatus result;
    private static final RouterStatusResponse DEFAULT_INSTANCE = new RouterStatusResponse();

    private RouterStatusResponse() {
        this.kind = null;
        this.result = null;
    }

    private RouterStatusResponse(String kind, RouterStatus result) {
        this.kind = kind;
        this.result = result;
    }

    public Object getFieldValue(String fieldName) {
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("result".equals(fieldName)) {
            return this.result;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKind() {
        return this.kind;
    }

    public RouterStatus getResult() {
        return this.result;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterStatusResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterStatusResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterStatusResponse{kind=" + this.kind + ", result=" + this.result + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterStatusResponse) {
            RouterStatusResponse that = (RouterStatusResponse)o;
            return Objects.equals(this.kind, that.getKind()) && Objects.equals(this.result, that.getResult());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.result);
    }

    public static class Builder {
        private String kind;
        private RouterStatus result;

        Builder() {
        }

        public Builder mergeFrom(RouterStatusResponse other) {
            if (other == RouterStatusResponse.getDefaultInstance()) {
                return this;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getResult() != null) {
                this.result = other.result;
            }
            return this;
        }

        Builder(RouterStatusResponse source) {
            this.kind = source.kind;
            this.result = source.result;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public RouterStatus getResult() {
            return this.result;
        }

        public Builder setResult(RouterStatus result) {
            this.result = result;
            return this;
        }

        public RouterStatusResponse build() {
            return new RouterStatusResponse(this.kind, this.result);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKind(this.kind);
            newBuilder.setResult(this.result);
            return newBuilder;
        }
    }
}

