/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneInstanceResourceName
implements ResourceName {
    private final String project;
    private final String resource;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/instances/{resource}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneInstanceResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.resource = (String)Preconditions.checkNotNull((Object)builder.getResource());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneInstanceResourceName of(String project, String resource, String zone) {
        return ProjectZoneInstanceResourceName.newBuilder().setProject(project).setResource(resource).setZone(zone).build();
    }

    public static String format(String project, String resource, String zone) {
        return ProjectZoneInstanceResourceName.of(project, resource, zone).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getResource() {
        return this.resource;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneInstanceResourceName projectZoneInstanceResourceName = this;
            synchronized (projectZoneInstanceResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"resource", (Object)this.resource);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneInstanceResourceName> newFactory() {
        return new ResourceNameFactory<ProjectZoneInstanceResourceName>(){

            public ProjectZoneInstanceResourceName parse(String formattedString) {
                return ProjectZoneInstanceResourceName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneInstanceResourceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneInstanceResourceName.parse: formattedString not in valid format");
        return ProjectZoneInstanceResourceName.of((String)matchMap.get("project"), (String)matchMap.get("resource"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "resource", this.resource, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneInstanceResourceName) {
            ProjectZoneInstanceResourceName that = (ProjectZoneInstanceResourceName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.resource, that.getResource()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.resource, this.zone);
    }

    public static class Builder {
        private String project;
        private String resource;
        private String zone;

        public String getProject() {
            return this.project;
        }

        public String getResource() {
            return this.resource;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneInstanceResourceName projectZoneInstanceResourceName) {
            this.project = projectZoneInstanceResourceName.project;
            this.resource = projectZoneInstanceResourceName.resource;
            this.zone = projectZoneInstanceResourceName.zone;
        }

        public ProjectZoneInstanceResourceName build() {
            return new ProjectZoneInstanceResourceName(this);
        }
    }
}

