/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalForwardingRuleName
implements ResourceName {
    private final String forwardingRule;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/forwardingRules/{forwardingRule}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalForwardingRuleName(Builder builder) {
        this.forwardingRule = (String)Preconditions.checkNotNull((Object)builder.getForwardingRule());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalForwardingRuleName of(String forwardingRule, String project) {
        return ProjectGlobalForwardingRuleName.newBuilder().setForwardingRule(forwardingRule).setProject(project).build();
    }

    public static String format(String forwardingRule, String project) {
        return ProjectGlobalForwardingRuleName.of(forwardingRule, project).toString();
    }

    public String getForwardingRule() {
        return this.forwardingRule;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalForwardingRuleName projectGlobalForwardingRuleName = this;
            synchronized (projectGlobalForwardingRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"forwardingRule", (Object)this.forwardingRule);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalForwardingRuleName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalForwardingRuleName>(){

            public ProjectGlobalForwardingRuleName parse(String formattedString) {
                return ProjectGlobalForwardingRuleName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalForwardingRuleName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalForwardingRuleName.parse: formattedString not in valid format");
        return ProjectGlobalForwardingRuleName.of((String)matchMap.get("forwardingRule"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"forwardingRule", this.forwardingRule, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalForwardingRuleName) {
            ProjectGlobalForwardingRuleName that = (ProjectGlobalForwardingRuleName)o;
            return Objects.equals(this.forwardingRule, that.getForwardingRule()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.forwardingRule, this.project);
    }

    public static class Builder {
        private String forwardingRule;
        private String project;

        public String getForwardingRule() {
            return this.forwardingRule;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setForwardingRule(String forwardingRule) {
            this.forwardingRule = forwardingRule;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalForwardingRuleName projectGlobalForwardingRuleName) {
            this.forwardingRule = projectGlobalForwardingRuleName.forwardingRule;
            this.project = projectGlobalForwardingRuleName.project;
        }

        public ProjectGlobalForwardingRuleName build() {
            return new ProjectGlobalForwardingRuleName(this);
        }
    }
}

