/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NodeTemplate;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NodeTemplatesScopedList
implements ApiMessage {
    private final List<NodeTemplate> nodeTemplates;
    private final Warning warning;
    private static final NodeTemplatesScopedList DEFAULT_INSTANCE = new NodeTemplatesScopedList();

    private NodeTemplatesScopedList() {
        this.nodeTemplates = null;
        this.warning = null;
    }

    private NodeTemplatesScopedList(List<NodeTemplate> nodeTemplates, Warning warning) {
        this.nodeTemplates = nodeTemplates;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("nodeTemplates".equals(fieldName)) {
            return this.nodeTemplates;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<NodeTemplate> getNodeTemplatesList() {
        return this.nodeTemplates;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeTemplatesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NodeTemplatesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NodeTemplatesScopedList{nodeTemplates=" + this.nodeTemplates + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeTemplatesScopedList) {
            NodeTemplatesScopedList that = (NodeTemplatesScopedList)o;
            return Objects.equals(this.nodeTemplates, that.getNodeTemplatesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nodeTemplates, this.warning);
    }

    public static class Builder {
        private List<NodeTemplate> nodeTemplates;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(NodeTemplatesScopedList other) {
            if (other == NodeTemplatesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getNodeTemplatesList() != null) {
                this.nodeTemplates = other.nodeTemplates;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(NodeTemplatesScopedList source) {
            this.nodeTemplates = source.nodeTemplates;
            this.warning = source.warning;
        }

        public List<NodeTemplate> getNodeTemplatesList() {
            return this.nodeTemplates;
        }

        public Builder addAllNodeTemplates(List<NodeTemplate> nodeTemplates) {
            if (this.nodeTemplates == null) {
                this.nodeTemplates = new LinkedList<NodeTemplate>();
            }
            this.nodeTemplates.addAll(nodeTemplates);
            return this;
        }

        public Builder addNodeTemplates(NodeTemplate nodeTemplates) {
            if (this.nodeTemplates == null) {
                this.nodeTemplates = new LinkedList<NodeTemplate>();
            }
            this.nodeTemplates.add(nodeTemplates);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public NodeTemplatesScopedList build() {
            return new NodeTemplatesScopedList(this.nodeTemplates, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllNodeTemplates(this.nodeTemplates);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

