/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ManagedInstanceVersion
implements ApiMessage {
    private final String instanceTemplate;
    private final String name;
    private static final ManagedInstanceVersion DEFAULT_INSTANCE = new ManagedInstanceVersion();

    private ManagedInstanceVersion() {
        this.instanceTemplate = null;
        this.name = null;
    }

    private ManagedInstanceVersion(String instanceTemplate, String name) {
        this.instanceTemplate = instanceTemplate;
        this.name = name;
    }

    public Object getFieldValue(String fieldName) {
        if ("instanceTemplate".equals(fieldName)) {
            return this.instanceTemplate;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInstanceTemplate() {
        return this.instanceTemplate;
    }

    public String getName() {
        return this.name;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ManagedInstanceVersion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ManagedInstanceVersion getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ManagedInstanceVersion{instanceTemplate=" + this.instanceTemplate + ", name=" + this.name + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ManagedInstanceVersion) {
            ManagedInstanceVersion that = (ManagedInstanceVersion)o;
            return Objects.equals(this.instanceTemplate, that.getInstanceTemplate()) && Objects.equals(this.name, that.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceTemplate, this.name);
    }

    public static class Builder {
        private String instanceTemplate;
        private String name;

        Builder() {
        }

        public Builder mergeFrom(ManagedInstanceVersion other) {
            if (other == ManagedInstanceVersion.getDefaultInstance()) {
                return this;
            }
            if (other.getInstanceTemplate() != null) {
                this.instanceTemplate = other.instanceTemplate;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            return this;
        }

        Builder(ManagedInstanceVersion source) {
            this.instanceTemplate = source.instanceTemplate;
            this.name = source.name;
        }

        public String getInstanceTemplate() {
            return this.instanceTemplate;
        }

        public Builder setInstanceTemplate(String instanceTemplate) {
            this.instanceTemplate = instanceTemplate;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public ManagedInstanceVersion build() {
            return new ManagedInstanceVersion(this.instanceTemplate, this.name);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInstanceTemplate(this.instanceTemplate);
            newBuilder.setName(this.name);
            return newBuilder;
        }
    }
}

