/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagersScopedList
implements ApiMessage {
    private final List<InstanceGroupManager> instanceGroupManagers;
    private final Warning warning;
    private static final InstanceGroupManagersScopedList DEFAULT_INSTANCE = new InstanceGroupManagersScopedList();

    private InstanceGroupManagersScopedList() {
        this.instanceGroupManagers = null;
        this.warning = null;
    }

    private InstanceGroupManagersScopedList(List<InstanceGroupManager> instanceGroupManagers, Warning warning) {
        this.instanceGroupManagers = instanceGroupManagers;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("instanceGroupManagers".equals(fieldName)) {
            return this.instanceGroupManagers;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<InstanceGroupManager> getInstanceGroupManagersList() {
        return this.instanceGroupManagers;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagersScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagersScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagersScopedList{instanceGroupManagers=" + this.instanceGroupManagers + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagersScopedList) {
            InstanceGroupManagersScopedList that = (InstanceGroupManagersScopedList)o;
            return Objects.equals(this.instanceGroupManagers, that.getInstanceGroupManagersList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceGroupManagers, this.warning);
    }

    public static class Builder {
        private List<InstanceGroupManager> instanceGroupManagers;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagersScopedList other) {
            if (other == InstanceGroupManagersScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getInstanceGroupManagersList() != null) {
                this.instanceGroupManagers = other.instanceGroupManagers;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(InstanceGroupManagersScopedList source) {
            this.instanceGroupManagers = source.instanceGroupManagers;
            this.warning = source.warning;
        }

        public List<InstanceGroupManager> getInstanceGroupManagersList() {
            return this.instanceGroupManagers;
        }

        public Builder addAllInstanceGroupManagers(List<InstanceGroupManager> instanceGroupManagers) {
            if (this.instanceGroupManagers == null) {
                this.instanceGroupManagers = new LinkedList<InstanceGroupManager>();
            }
            this.instanceGroupManagers.addAll(instanceGroupManagers);
            return this;
        }

        public Builder addInstanceGroupManagers(InstanceGroupManager instanceGroupManagers) {
            if (this.instanceGroupManagers == null) {
                this.instanceGroupManagers = new LinkedList<InstanceGroupManager>();
            }
            this.instanceGroupManagers.add(instanceGroupManagers);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public InstanceGroupManagersScopedList build() {
            return new InstanceGroupManagersScopedList(this.instanceGroupManagers, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstanceGroupManagers(this.instanceGroupManagers);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

