/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendServicesScopedList
implements ApiMessage {
    private final List<BackendService> backendServices;
    private final Warning warning;
    private static final BackendServicesScopedList DEFAULT_INSTANCE = new BackendServicesScopedList();

    private BackendServicesScopedList() {
        this.backendServices = null;
        this.warning = null;
    }

    private BackendServicesScopedList(List<BackendService> backendServices, Warning warning) {
        this.backendServices = backendServices;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("backendServices".equals(fieldName)) {
            return this.backendServices;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<BackendService> getBackendServicesList() {
        return this.backendServices;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendServicesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendServicesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendServicesScopedList{backendServices=" + this.backendServices + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendServicesScopedList) {
            BackendServicesScopedList that = (BackendServicesScopedList)o;
            return Objects.equals(this.backendServices, that.getBackendServicesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendServices, this.warning);
    }

    public static class Builder {
        private List<BackendService> backendServices;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(BackendServicesScopedList other) {
            if (other == BackendServicesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getBackendServicesList() != null) {
                this.backendServices = other.backendServices;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(BackendServicesScopedList source) {
            this.backendServices = source.backendServices;
            this.warning = source.warning;
        }

        public List<BackendService> getBackendServicesList() {
            return this.backendServices;
        }

        public Builder addAllBackendServices(List<BackendService> backendServices) {
            if (this.backendServices == null) {
                this.backendServices = new LinkedList<BackendService>();
            }
            this.backendServices.addAll(backendServices);
            return this;
        }

        public Builder addBackendServices(BackendService backendServices) {
            if (this.backendServices == null) {
                this.backendServices = new LinkedList<BackendService>();
            }
            this.backendServices.add(backendServices);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public BackendServicesScopedList build() {
            return new BackendServicesScopedList(this.backendServices, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllBackendServices(this.backendServices);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

