/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Address
implements ApiMessage {
    private final String address;
    private final String addressType;
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String ipVersion;
    private final String kind;
    private final String name;
    private final String network;
    private final String networkTier;
    private final Integer prefixLength;
    private final String purpose;
    private final String region;
    private final String selfLink;
    private final String status;
    private final String subnetwork;
    private final List<String> users;
    private static final Address DEFAULT_INSTANCE = new Address();

    private Address() {
        this.address = null;
        this.addressType = null;
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.ipVersion = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.networkTier = null;
        this.prefixLength = null;
        this.purpose = null;
        this.region = null;
        this.selfLink = null;
        this.status = null;
        this.subnetwork = null;
        this.users = null;
    }

    private Address(String address, String addressType, String creationTimestamp, String description, String id, String ipVersion, String kind, String name, String network, String networkTier, Integer prefixLength, String purpose, String region, String selfLink, String status, String subnetwork, List<String> users) {
        this.address = address;
        this.addressType = addressType;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.ipVersion = ipVersion;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.networkTier = networkTier;
        this.prefixLength = prefixLength;
        this.purpose = purpose;
        this.region = region;
        this.selfLink = selfLink;
        this.status = status;
        this.subnetwork = subnetwork;
        this.users = users;
    }

    public Object getFieldValue(String fieldName) {
        if ("address".equals(fieldName)) {
            return this.address;
        }
        if ("addressType".equals(fieldName)) {
            return this.addressType;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("ipVersion".equals(fieldName)) {
            return this.ipVersion;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("networkTier".equals(fieldName)) {
            return this.networkTier;
        }
        if ("prefixLength".equals(fieldName)) {
            return this.prefixLength;
        }
        if ("purpose".equals(fieldName)) {
            return this.purpose;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("subnetwork".equals(fieldName)) {
            return this.subnetwork;
        }
        if ("users".equals(fieldName)) {
            return this.users;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getIpVersion() {
        return this.ipVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkTier() {
        return this.networkTier;
    }

    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public List<String> getUsersList() {
        return this.users;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Address prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Address getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Address{address=" + this.address + ", addressType=" + this.addressType + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", ipVersion=" + this.ipVersion + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", networkTier=" + this.networkTier + ", prefixLength=" + this.prefixLength + ", purpose=" + this.purpose + ", region=" + this.region + ", selfLink=" + this.selfLink + ", status=" + this.status + ", subnetwork=" + this.subnetwork + ", users=" + this.users + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Address) {
            Address that = (Address)o;
            return Objects.equals(this.address, that.getAddress()) && Objects.equals(this.addressType, that.getAddressType()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.ipVersion, that.getIpVersion()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.networkTier, that.getNetworkTier()) && Objects.equals(this.prefixLength, that.getPrefixLength()) && Objects.equals(this.purpose, that.getPurpose()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.subnetwork, that.getSubnetwork()) && Objects.equals(this.users, that.getUsersList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.addressType, this.creationTimestamp, this.description, this.id, this.ipVersion, this.kind, this.name, this.network, this.networkTier, this.prefixLength, this.purpose, this.region, this.selfLink, this.status, this.subnetwork, this.users);
    }

    public static class Builder {
        private String address;
        private String addressType;
        private String creationTimestamp;
        private String description;
        private String id;
        private String ipVersion;
        private String kind;
        private String name;
        private String network;
        private String networkTier;
        private Integer prefixLength;
        private String purpose;
        private String region;
        private String selfLink;
        private String status;
        private String subnetwork;
        private List<String> users;

        Builder() {
        }

        public Builder mergeFrom(Address other) {
            if (other == Address.getDefaultInstance()) {
                return this;
            }
            if (other.getAddress() != null) {
                this.address = other.address;
            }
            if (other.getAddressType() != null) {
                this.addressType = other.addressType;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getIpVersion() != null) {
                this.ipVersion = other.ipVersion;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getNetworkTier() != null) {
                this.networkTier = other.networkTier;
            }
            if (other.getPrefixLength() != null) {
                this.prefixLength = other.prefixLength;
            }
            if (other.getPurpose() != null) {
                this.purpose = other.purpose;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            if (other.getUsersList() != null) {
                this.users = other.users;
            }
            return this;
        }

        Builder(Address source) {
            this.address = source.address;
            this.addressType = source.addressType;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.ipVersion = source.ipVersion;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.networkTier = source.networkTier;
            this.prefixLength = source.prefixLength;
            this.purpose = source.purpose;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.status = source.status;
            this.subnetwork = source.subnetwork;
            this.users = source.users;
        }

        public String getAddress() {
            return this.address;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public String getAddressType() {
            return this.addressType;
        }

        public Builder setAddressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getIpVersion() {
            return this.ipVersion;
        }

        public Builder setIpVersion(String ipVersion) {
            this.ipVersion = ipVersion;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getNetworkTier() {
            return this.networkTier;
        }

        public Builder setNetworkTier(String networkTier) {
            this.networkTier = networkTier;
            return this;
        }

        public Integer getPrefixLength() {
            return this.prefixLength;
        }

        public Builder setPrefixLength(Integer prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public Builder setPurpose(String purpose) {
            this.purpose = purpose;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public List<String> getUsersList() {
            return this.users;
        }

        public Builder addAllUsers(List<String> users) {
            if (this.users == null) {
                this.users = new LinkedList<String>();
            }
            this.users.addAll(users);
            return this;
        }

        public Builder addUsers(String users) {
            if (this.users == null) {
                this.users = new LinkedList<String>();
            }
            this.users.add(users);
            return this;
        }

        public Address build() {
            return new Address(this.address, this.addressType, this.creationTimestamp, this.description, this.id, this.ipVersion, this.kind, this.name, this.network, this.networkTier, this.prefixLength, this.purpose, this.region, this.selfLink, this.status, this.subnetwork, this.users);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAddress(this.address);
            newBuilder.setAddressType(this.addressType);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setIpVersion(this.ipVersion);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setNetworkTier(this.networkTier);
            newBuilder.setPrefixLength(this.prefixLength);
            newBuilder.setPurpose(this.purpose);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setStatus(this.status);
            newBuilder.setSubnetwork(this.subnetwork);
            newBuilder.addAllUsers(this.users);
            return newBuilder;
        }
    }
}

