/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DeprecationStatus;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AcceleratorType
implements ApiMessage {
    private final String creationTimestamp;
    private final DeprecationStatus deprecated;
    private final String description;
    private final String id;
    private final String kind;
    private final Integer maximumCardsPerInstance;
    private final String name;
    private final String selfLink;
    private final String zone;
    private static final AcceleratorType DEFAULT_INSTANCE = new AcceleratorType();

    private AcceleratorType() {
        this.creationTimestamp = null;
        this.deprecated = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.maximumCardsPerInstance = null;
        this.name = null;
        this.selfLink = null;
        this.zone = null;
    }

    private AcceleratorType(String creationTimestamp, DeprecationStatus deprecated, String description, String id, String kind, Integer maximumCardsPerInstance, String name, String selfLink, String zone) {
        this.creationTimestamp = creationTimestamp;
        this.deprecated = deprecated;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.maximumCardsPerInstance = maximumCardsPerInstance;
        this.name = name;
        this.selfLink = selfLink;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("deprecated".equals(fieldName)) {
            return this.deprecated;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("maximumCardsPerInstance".equals(fieldName)) {
            return this.maximumCardsPerInstance;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public Integer getMaximumCardsPerInstance() {
        return this.maximumCardsPerInstance;
    }

    public String getName() {
        return this.name;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AcceleratorType prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AcceleratorType getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AcceleratorType{creationTimestamp=" + this.creationTimestamp + ", deprecated=" + this.deprecated + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", maximumCardsPerInstance=" + this.maximumCardsPerInstance + ", name=" + this.name + ", selfLink=" + this.selfLink + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AcceleratorType) {
            AcceleratorType that = (AcceleratorType)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.deprecated, that.getDeprecated()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.maximumCardsPerInstance, that.getMaximumCardsPerInstance()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.deprecated, this.description, this.id, this.kind, this.maximumCardsPerInstance, this.name, this.selfLink, this.zone);
    }

    public static class Builder {
        private String creationTimestamp;
        private DeprecationStatus deprecated;
        private String description;
        private String id;
        private String kind;
        private Integer maximumCardsPerInstance;
        private String name;
        private String selfLink;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(AcceleratorType other) {
            if (other == AcceleratorType.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDeprecated() != null) {
                this.deprecated = other.deprecated;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getMaximumCardsPerInstance() != null) {
                this.maximumCardsPerInstance = other.maximumCardsPerInstance;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(AcceleratorType source) {
            this.creationTimestamp = source.creationTimestamp;
            this.deprecated = source.deprecated;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.maximumCardsPerInstance = source.maximumCardsPerInstance;
            this.name = source.name;
            this.selfLink = source.selfLink;
            this.zone = source.zone;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public DeprecationStatus getDeprecated() {
            return this.deprecated;
        }

        public Builder setDeprecated(DeprecationStatus deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public Integer getMaximumCardsPerInstance() {
            return this.maximumCardsPerInstance;
        }

        public Builder setMaximumCardsPerInstance(Integer maximumCardsPerInstance) {
            this.maximumCardsPerInstance = maximumCardsPerInstance;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public AcceleratorType build() {
            return new AcceleratorType(this.creationTimestamp, this.deprecated, this.description, this.id, this.kind, this.maximumCardsPerInstance, this.name, this.selfLink, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDeprecated(this.deprecated);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setMaximumCardsPerInstance(this.maximumCardsPerInstance);
            newBuilder.setName(this.name);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

