/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.temporal.TemporalAccessor;

public final class DeprecationStatus<T extends ResourceId>
implements Serializable {
    private static final long serialVersionUID = -2695077634793679794L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone((ZoneId)ZoneOffset.UTC);
    private final String deleted;
    private final String deprecated;
    private final String obsolete;
    private final T replacement;
    private final Status status;

    DeprecationStatus(Builder<T> builder) {
        this.deleted = ((Builder)builder).deleted;
        this.deprecated = ((Builder)builder).deprecated;
        this.obsolete = ((Builder)builder).obsolete;
        this.replacement = ((Builder)builder).replacement;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)((Builder)builder).status)));
    }

    public String getDeleted() {
        return this.deleted;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getObsolete() {
        return this.obsolete;
    }

    public Long getDeletedMillis() {
        try {
            return this.deleted != null ? Long.valueOf(((Instant)TIMESTAMP_FORMATTER.parse((CharSequence)this.deleted, Instant.FROM)).toEpochMilli()) : null;
        }
        catch (DateTimeParseException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public Long getDeprecatedMillis() {
        try {
            return this.deprecated != null ? Long.valueOf(((Instant)TIMESTAMP_FORMATTER.parse((CharSequence)this.deprecated, Instant.FROM)).toEpochMilli()) : null;
        }
        catch (DateTimeParseException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public Long getObsoleteMillis() {
        try {
            return this.obsolete != null ? Long.valueOf(((Instant)TIMESTAMP_FORMATTER.parse((CharSequence)this.obsolete, Instant.FROM)).toEpochMilli()) : null;
        }
        catch (DateTimeParseException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public T getReplacement() {
        return this.replacement;
    }

    public Status getStatus() {
        return this.status;
    }

    public Builder<T> toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deleted", (Object)this.deleted).add("deprecated", (Object)this.deprecated).add("obsolete", (Object)this.obsolete).add("replacement", this.replacement).add("status", (Object)this.status).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deleted, this.deprecated, this.obsolete, this.replacement, this.status});
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DeprecationStatus && Objects.equals(this.toPb(), ((DeprecationStatus)obj).toPb());
    }

    com.google.api.services.compute.model.DeprecationStatus toPb() {
        com.google.api.services.compute.model.DeprecationStatus deprecationStatusPb = new com.google.api.services.compute.model.DeprecationStatus();
        deprecationStatusPb.setDeleted(this.deleted);
        deprecationStatusPb.setDeprecated(this.deprecated);
        deprecationStatusPb.setObsolete(this.obsolete);
        deprecationStatusPb.setReplacement(((ResourceId)this.replacement).getSelfLink());
        deprecationStatusPb.setState(this.status.name());
        return deprecationStatusPb;
    }

    public static <T extends ResourceId> Builder<T> newBuilder(Status status) {
        return new Builder().setStatus(status);
    }

    public static <T extends ResourceId> Builder<T> newBuilder(Status status, T replacement) {
        return new Builder().setStatus(status).setReplacement(replacement);
    }

    public static <T extends ResourceId> DeprecationStatus<T> of(Status status, T replacement) {
        return DeprecationStatus.newBuilder(status, replacement).build();
    }

    static <T extends ResourceId> DeprecationStatus<T> fromPb(com.google.api.services.compute.model.DeprecationStatus deprecationStatusPb, Function<String, T> fromUrl) {
        Builder<ResourceId> builder = new Builder<ResourceId>();
        builder.setDeleted(deprecationStatusPb.getDeleted());
        builder.setDeprecated(deprecationStatusPb.getDeprecated());
        builder.setObsolete(deprecationStatusPb.getObsolete());
        if (deprecationStatusPb.getReplacement() != null) {
            builder.setReplacement((ResourceId)fromUrl.apply((Object)deprecationStatusPb.getReplacement()));
        }
        if (deprecationStatusPb.getState() != null) {
            builder.setStatus(Status.valueOf(deprecationStatusPb.getState()));
        }
        return builder.build();
    }

    public static final class Builder<T extends ResourceId> {
        private String deleted;
        private String deprecated;
        private String obsolete;
        private T replacement;
        private Status status;

        Builder() {
        }

        Builder(DeprecationStatus<T> deprecationStatus) {
            this.deleted = ((DeprecationStatus)deprecationStatus).deleted;
            this.deprecated = ((DeprecationStatus)deprecationStatus).deprecated;
            this.obsolete = ((DeprecationStatus)deprecationStatus).obsolete;
            this.replacement = ((DeprecationStatus)deprecationStatus).replacement;
            this.status = ((DeprecationStatus)deprecationStatus).status;
        }

        Builder<T> setDeleted(String deleted) {
            this.deleted = deleted;
            return this;
        }

        Builder<T> setDeprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        Builder<T> setObsolete(String obsolete) {
            this.obsolete = obsolete;
            return this;
        }

        public Builder<T> setDeleted(long deleted) {
            this.deleted = TIMESTAMP_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((long)deleted));
            return this;
        }

        public Builder<T> setDeprecated(long deprecated) {
            this.deprecated = TIMESTAMP_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((long)deprecated));
            return this;
        }

        public Builder<T> setObsolete(long obsolete) {
            this.obsolete = TIMESTAMP_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((long)obsolete));
            return this;
        }

        public Builder<T> setReplacement(T replacement) {
            this.replacement = replacement;
            return this;
        }

        public Builder<T> setStatus(Status status) {
            this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
            return this;
        }

        public DeprecationStatus<T> build() {
            return new DeprecationStatus(this);
        }
    }

    public static enum Status {
        DEPRECATED,
        OBSOLETE,
        DELETED;

    }
}

