/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpsHealthCheck2;
import com.google.cloud.compute.v1.HttpsHealthCheckClient;
import com.google.cloud.compute.v1.HttpsHealthCheckList;
import com.google.cloud.compute.v1.InsertHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpsHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalHttpsHealthCheckName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonHttpsHealthCheckCallableFactory;
import com.google.cloud.compute.v1.stub.HttpsHealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpsHealthCheckStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonHttpsHealthCheckStub
extends HttpsHealthCheckStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpsHealthChecks.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpsHealthChecks/{httpsHealthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHttpsHealthCheckName.newFactory()).setResourceNameField("httpsHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpsHealthChecks.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpsHealthChecks/{httpsHealthCheck}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalHttpsHealthCheckName.newFactory()).setResourceNameField("httpsHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HttpsHealthCheck2.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpsHealthChecks.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpsHealthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList> listHttpsHealthChecksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpsHealthChecks.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpsHealthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HttpsHealthCheckList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpsHealthChecks.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpsHealthChecks/{httpsHealthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHttpsHealthCheckName.newFactory()).setResourceNameField("httpsHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpsHealthChecks.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpsHealthChecks/{httpsHealthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHttpsHealthCheckName.newFactory()).setResourceNameField("httpsHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckCallable;
    private final UnaryCallable<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckCallable;
    private final UnaryCallable<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckCallable;
    private final UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList> listHttpsHealthChecksCallable;
    private final UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksPagedCallable;
    private final UnaryCallable<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckCallable;
    private final UnaryCallable<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonHttpsHealthCheckStub create(HttpsHealthCheckStubSettings settings) throws IOException {
        return new HttpJsonHttpsHealthCheckStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonHttpsHealthCheckStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonHttpsHealthCheckStub(HttpsHealthCheckStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonHttpsHealthCheckStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonHttpsHealthCheckStub(HttpsHealthCheckStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonHttpsHealthCheckStub(HttpsHealthCheckStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonHttpsHealthCheckCallableFactory());
    }

    protected HttpJsonHttpsHealthCheckStub(HttpsHealthCheckStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteHttpsHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteHttpsHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings getHttpsHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getHttpsHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings insertHttpsHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertHttpsHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings listHttpsHealthChecksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listHttpsHealthChecksMethodDescriptor).build();
        HttpJsonCallSettings patchHttpsHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchHttpsHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings updateHttpsHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateHttpsHealthCheckMethodDescriptor).build();
        this.deleteHttpsHealthCheckCallable = callableFactory.createUnaryCallable(deleteHttpsHealthCheckTransportSettings, settings.deleteHttpsHealthCheckSettings(), clientContext);
        this.getHttpsHealthCheckCallable = callableFactory.createUnaryCallable(getHttpsHealthCheckTransportSettings, settings.getHttpsHealthCheckSettings(), clientContext);
        this.insertHttpsHealthCheckCallable = callableFactory.createUnaryCallable(insertHttpsHealthCheckTransportSettings, settings.insertHttpsHealthCheckSettings(), clientContext);
        this.listHttpsHealthChecksCallable = callableFactory.createUnaryCallable(listHttpsHealthChecksTransportSettings, settings.listHttpsHealthChecksSettings(), clientContext);
        this.listHttpsHealthChecksPagedCallable = callableFactory.createPagedCallable(listHttpsHealthChecksTransportSettings, settings.listHttpsHealthChecksSettings(), clientContext);
        this.patchHttpsHealthCheckCallable = callableFactory.createUnaryCallable(patchHttpsHealthCheckTransportSettings, settings.patchHttpsHealthCheckSettings(), clientContext);
        this.updateHttpsHealthCheckCallable = callableFactory.createUnaryCallable(updateHttpsHealthCheckTransportSettings, settings.updateHttpsHealthCheckSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckCallable() {
        return this.deleteHttpsHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckCallable() {
        return this.getHttpsHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckCallable() {
        return this.insertHttpsHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksPagedCallable() {
        return this.listHttpsHealthChecksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList> listHttpsHealthChecksCallable() {
        return this.listHttpsHealthChecksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckCallable() {
        return this.patchHttpsHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckCallable() {
        return this.updateHttpsHealthCheckCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

