/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.ImageConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class StorageImageConfiguration
extends ImageConfiguration {
    private static final long serialVersionUID = 8160447986545005880L;
    private final ContainerType containerType;
    private final String sha1;
    private final String source;

    private StorageImageConfiguration(Builder builder) {
        super(builder);
        this.source = (String)Preconditions.checkNotNull((Object)builder.source);
        this.containerType = builder.containerType;
        this.sha1 = builder.sha1;
    }

    @Deprecated
    public ContainerType containerType() {
        return this.getContainerType();
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Deprecated
    public String sha1() {
        return this.getSha1();
    }

    public String getSha1() {
        return this.sha1;
    }

    @Deprecated
    public String source() {
        return this.getSource();
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("source", (Object)this.source).add("containerType", (Object)this.containerType).add("sha1", (Object)this.sha1);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.source, this.containerType, this.sha1});
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(StorageImageConfiguration.class) && Objects.equals(this.toPb(), ((StorageImageConfiguration)obj).toPb());
    }

    @Override
    StorageImageConfiguration setProjectId(String projectId) {
        return this;
    }

    @Override
    Image toPb() {
        Image.RawDisk rawDiskPb = new Image.RawDisk();
        rawDiskPb.setSource(this.source);
        rawDiskPb.setSha1Checksum(this.sha1);
        if (this.containerType != null) {
            rawDiskPb.setContainerType(this.containerType.name());
        }
        Image imagePb = super.toPb();
        return imagePb.setRawDisk(rawDiskPb);
    }

    @Deprecated
    public static Builder builder(String source) {
        return StorageImageConfiguration.newBuilder(source);
    }

    public static Builder newBuilder(String source) {
        return new Builder().setSource(source);
    }

    public static StorageImageConfiguration of(String source) {
        return StorageImageConfiguration.newBuilder(source).build();
    }

    static StorageImageConfiguration fromPb(Image imagePb) {
        return new Builder(imagePb).build();
    }

    public static final class Builder
    extends ImageConfiguration.Builder<StorageImageConfiguration, Builder> {
        private ContainerType containerType;
        private String sha1;
        private String source;

        private Builder() {
            super(ImageConfiguration.Type.STORAGE);
        }

        private Builder(StorageImageConfiguration imageConfiguration) {
            super(imageConfiguration);
            this.containerType = imageConfiguration.containerType;
            this.sha1 = imageConfiguration.sha1;
            this.source = imageConfiguration.source;
        }

        private Builder(Image imagePb) {
            super(ImageConfiguration.Type.STORAGE, imagePb);
            if (imagePb.getRawDisk().getContainerType() != null) {
                this.containerType = ContainerType.valueOf(imagePb.getRawDisk().getContainerType());
            }
            this.sha1 = imagePb.getRawDisk().getSha1Checksum();
            this.source = imagePb.getRawDisk().getSource();
        }

        @Deprecated
        public Builder containerType(ContainerType containerType) {
            return this.setContainerType(containerType);
        }

        public Builder setContainerType(ContainerType containerType) {
            this.containerType = containerType;
            return this;
        }

        @Deprecated
        public Builder sha1(String sha1) {
            return this.setSha1(sha1);
        }

        public Builder setSha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        @Deprecated
        public Builder source(String source) {
            return this.setSource(source);
        }

        public Builder setSource(String source) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            return this;
        }

        @Override
        public StorageImageConfiguration build() {
            return new StorageImageConfiguration(this);
        }
    }

    public static enum ContainerType {
        TAR;

    }
}

