/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Metadata;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Metadata
implements Serializable {
    static final Function<com.google.api.services.compute.model.Metadata, Metadata> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.Metadata, Metadata>(){

        public Metadata apply(com.google.api.services.compute.model.Metadata pb) {
            return Metadata.fromPb(pb);
        }
    };
    static final Function<Metadata, com.google.api.services.compute.model.Metadata> TO_PB_FUNCTION = new Function<Metadata, com.google.api.services.compute.model.Metadata>(){

        public com.google.api.services.compute.model.Metadata apply(Metadata metadata) {
            return metadata.toPb();
        }
    };
    private static final long serialVersionUID = -945038809838910107L;
    private final Map<String, String> values;
    private final String fingerprint;

    private Metadata(Builder builder) {
        this.values = ImmutableMap.copyOf((Map)builder.values);
        this.fingerprint = builder.fingerprint;
    }

    @Deprecated
    public Map<String, String> values() {
        return this.values;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    @Deprecated
    public String fingerprint() {
        return this.fingerprint;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).add("fingerprint", (Object)this.fingerprint).toString();
    }

    public int hashCode() {
        return Objects.hash(this.values, this.fingerprint);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Metadata && Objects.equals(this.toPb(), ((Metadata)obj).toPb());
    }

    com.google.api.services.compute.model.Metadata toPb() {
        com.google.api.services.compute.model.Metadata metadataPb = new com.google.api.services.compute.model.Metadata();
        metadataPb.setFingerprint(this.fingerprint);
        ArrayList itemsPb = Lists.newArrayListWithCapacity((int)this.values.size());
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            itemsPb.add(new Metadata.Items().setKey(entry.getKey()).setValue(entry.getValue()));
        }
        metadataPb.setItems((List)itemsPb);
        metadataPb.setFingerprint(this.fingerprint);
        return metadataPb;
    }

    @Deprecated
    public static Builder builder() {
        return Metadata.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Metadata of(Map<String, String> values) {
        return Metadata.newBuilder().setValues(values).build();
    }

    static Metadata fromPb(com.google.api.services.compute.model.Metadata metadataPb) {
        Builder builder = Metadata.newBuilder();
        if (metadataPb.getItems() != null) {
            HashMap metadataValues = Maps.newHashMapWithExpectedSize((int)metadataPb.getItems().size());
            for (Metadata.Items item : metadataPb.getItems()) {
                metadataValues.put(item.getKey(), item.getValue());
            }
            builder.setValues(metadataValues);
        }
        return builder.setFingerprint(metadataPb.getFingerprint()).build();
    }

    public static final class Builder {
        private Map<String, String> values;
        private String fingerprint;

        Builder() {
            this.values = Maps.newHashMap();
        }

        Builder(Metadata metadata) {
            this.values = metadata.values != null ? Maps.newHashMap((Map)metadata.values) : Maps.newHashMap();
            this.fingerprint = metadata.fingerprint;
        }

        @Deprecated
        public Builder values(Map<String, String> values) {
            return this.setValues(values);
        }

        public Builder setValues(Map<String, String> values) {
            this.values = Maps.newHashMap((Map)((Map)Preconditions.checkNotNull(values)));
            return this;
        }

        public Builder add(String key, String value) {
            this.values.put(key, value);
            return this;
        }

        @Deprecated
        public Builder fingerprint(String fingerprint) {
            return this.setFingerprint(fingerprint);
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Metadata build() {
            return new Metadata(this);
        }
    }
}

