/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class ImageDiskConfiguration
extends DiskConfiguration {
    private static final long serialVersionUID = 6469117882950722812L;
    private final ImageId sourceImage;
    private final String sourceImageId;

    private ImageDiskConfiguration(Builder builder) {
        super(builder);
        this.sourceImage = builder.sourceImage;
        this.sourceImageId = builder.sourceImageId;
    }

    @Deprecated
    public ImageId sourceImage() {
        return this.getSourceImage();
    }

    public ImageId getSourceImage() {
        return this.sourceImage;
    }

    @Deprecated
    public String sourceImageId() {
        return this.getSourceImageId();
    }

    public String getSourceImageId() {
        return this.sourceImageId;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceImage", (Object)this.sourceImage).add("sourceImageId", (Object)this.sourceImageId);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceImage, this.sourceImageId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ImageDiskConfiguration.class) && this.baseEquals((ImageDiskConfiguration)obj);
    }

    @Override
    ImageDiskConfiguration setProjectId(String projectId) {
        Builder builder = this.toBuilder().setSourceImage(this.sourceImage.setProjectId(projectId));
        if (this.getDiskType() != null) {
            builder.setDiskType(this.getDiskType().setProjectId(projectId));
        }
        return builder.build();
    }

    @Override
    Disk toPb() {
        return super.toPb().setSourceImage(this.sourceImage.getSelfLink()).setSourceImageId(this.sourceImageId);
    }

    @Deprecated
    public static Builder builder(ImageId imageId) {
        return ImageDiskConfiguration.newBuilder(imageId);
    }

    public static Builder newBuilder(ImageId imageId) {
        return new Builder(imageId);
    }

    public static ImageDiskConfiguration of(ImageId imageId) {
        return ImageDiskConfiguration.newBuilder(imageId).build();
    }

    static ImageDiskConfiguration fromPb(Disk diskPb) {
        return new Builder(diskPb).build();
    }

    public static class Builder
    extends DiskConfiguration.Builder<ImageDiskConfiguration, Builder> {
        private ImageId sourceImage;
        private String sourceImageId;

        private Builder(ImageId sourceImage) {
            super(DiskConfiguration.Type.IMAGE);
            this.sourceImage = (ImageId)Preconditions.checkNotNull((Object)sourceImage);
        }

        private Builder(ImageDiskConfiguration configuration) {
            super(configuration);
            this.sourceImage = configuration.sourceImage;
            this.sourceImageId = configuration.sourceImageId;
        }

        private Builder(Disk diskPb) {
            super(DiskConfiguration.Type.IMAGE, diskPb);
            this.sourceImage = ImageId.fromUrl(diskPb.getSourceImage());
            this.sourceImageId = diskPb.getSourceImageId();
        }

        @Override
        @Deprecated
        public Builder sizeGb(Long sizeGb) {
            return this.setSizeGb(sizeGb);
        }

        @Override
        public Builder setSizeGb(Long sizeGb) {
            super.setSizeGb(sizeGb);
            return this;
        }

        @Deprecated
        public Builder sourceImage(ImageId sourceImage) {
            return this.setSourceImage(sourceImage);
        }

        public Builder setSourceImage(ImageId sourceImage) {
            this.sourceImage = (ImageId)Preconditions.checkNotNull((Object)sourceImage);
            return this;
        }

        Builder setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        @Override
        public ImageDiskConfiguration build() {
            return new ImageDiskConfiguration(this);
        }
    }
}

